/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.google.common.base.Predicate;
import com.mgen256.al.blocks.LampAndTorchBase;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ALTorch
extends LampAndTorchBase {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });
    private static AxisAlignedBB[] SHAPES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.34375, 0.125, 0.6875, 0.65625, 0.8125, 1.0), new AxisAlignedBB(0.34375, 0.125, 0.0, 0.65625, 0.8125, 0.3125), new AxisAlignedBB(0.6875, 0.125, 0.34375, 1.0, 0.8125, 0.65625), new AxisAlignedBB(0.0, 0.125, 0.34375, 0.3125, 0.8125, 0.65625)};

    public ALTorch(Block mainblock, String mainblockName) {
        super("al_torch_", mainblock, mainblockName, Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
        this.field_149784_t = 14;
    }

    @Override
    protected PropertyDirection getFacing() {
        return FACING;
    }

    public IBlockState func_176203_a(int meta) {
        if (!(1 <= meta && meta < this.getMaxMeta())) {
            meta = 1;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.getFacing(), (Comparable)EnumFacing.values()[meta]);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !this.isExceptBlockForAttachWithPiston2(block) && blockfaceshape == BlockFaceShape.SOLID;
        }
        return false;
    }

    @Override
    protected AxisAlignedBB getShapes(IBlockState state) {
        int index = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (index <= 0 || this.getMaxMeta() < index) {
            return field_185506_k;
        }
        return SHAPES[index - 1];
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, blockpos)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double dx = (double)pos.func_177958_n() + 0.5;
        double dy = pos.func_177956_o();
        double dz = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.38;
        if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, dx + d3 * (double)enumfacing1.func_82601_c(), dy += 0.9, dz + d3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, dx + d3 * (double)enumfacing1.func_82601_c(), dy, dz + d3 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, dx, dy += 0.7, dz, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, dx, dy, dz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected boolean isExceptionBlockForAttaching2(Block attachBlock) {
        return attachBlock instanceof BlockShulkerBox || attachBlock instanceof BlockLeaves || attachBlock instanceof BlockTrapDoor || attachBlock == Blocks.field_150461_bJ || attachBlock == Blocks.field_150383_bp || attachBlock == Blocks.field_150426_aN || attachBlock == Blocks.field_150432_aD || attachBlock == Blocks.field_180398_cJ || attachBlock == Blocks.field_150399_cn;
    }
}

