/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.FireBlockList;
import com.mgen256.al.blocks.ModBlock;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Fire
extends ModBlock {
    private static Map<FireBlockList, AxisAlignedBB> SHAPES = new LinkedHashMap<FireBlockList, AxisAlignedBB>();
    private static Map<FireBlockList, EnumParticleTypes> PARTICLE_TYPES;
    private static Map<FireBlockList, Double> SMOKE_POS;
    private FireBlockList baseFireBlock;

    public Fire(FireBlockList _baseFireBlock) {
        super("fire_for_" + (Object)((Object)_baseFireBlock), null, null, Material.field_151581_o);
        this.baseFireBlock = _baseFireBlock;
        this.field_149782_v = 0.0f;
        this.field_149784_t = 15;
        this.func_149675_a(true);
        this.func_149672_a(new SoundType(0.5f, 2.0f, SoundEvents.field_187546_ae, SoundEvents.field_187554_ai, SoundEvents.field_187845_fY, SoundEvents.field_187550_ag, SoundEvents.field_187548_af));
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151660_b;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    protected AxisAlignedBB getShapes(IBlockState state) {
        return SHAPES.get((Object)this.baseFireBlock);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + SMOKE_POS.get((Object)this.baseFireBlock);
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_175688_a(PARTICLE_TYPES.get((Object)this.baseFireBlock), d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    static {
        SHAPES.put(FireBlockList.standing_torch_s, new AxisAlignedBB(0.25, -0.375, 0.25, 0.75, 0.125, 0.75));
        SHAPES.put(FireBlockList.standing_torch_l, new AxisAlignedBB(0.25, -0.125, 0.25, 0.75, 0.375, 0.75));
        SHAPES.put(FireBlockList.fire_pit_s, new AxisAlignedBB(0.0, -0.625, 0.0, 1.0, 0.1, 1.0));
        SHAPES.put(FireBlockList.fire_pit_l, new AxisAlignedBB(0.0, -0.125, 0.0, 1.0, 0.4375, 1.0));
        PARTICLE_TYPES = new LinkedHashMap<FireBlockList, EnumParticleTypes>();
        PARTICLE_TYPES.put(FireBlockList.standing_torch_s, EnumParticleTypes.SMOKE_NORMAL);
        PARTICLE_TYPES.put(FireBlockList.standing_torch_l, EnumParticleTypes.SMOKE_NORMAL);
        PARTICLE_TYPES.put(FireBlockList.fire_pit_s, EnumParticleTypes.SMOKE_LARGE);
        PARTICLE_TYPES.put(FireBlockList.fire_pit_l, EnumParticleTypes.SMOKE_LARGE);
        SMOKE_POS = new LinkedHashMap<FireBlockList, Double>();
        SMOKE_POS.put(FireBlockList.standing_torch_s, 0.2);
        SMOKE_POS.put(FireBlockList.standing_torch_l, 0.7);
        SMOKE_POS.put(FireBlockList.fire_pit_s, 0.0);
        SMOKE_POS.put(FireBlockList.fire_pit_l, 0.8);
    }
}

