/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.FireBlockList;
import com.mgen256.al.blocks.ModBlock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class Fire
extends ModBlock {
    private static Map<FireBlockList, VoxelShape> SHAPES = new LinkedHashMap<FireBlockList, VoxelShape>();
    private static Map<FireBlockList, BasicParticleType> PARTICLE_TYPES;
    private static Map<FireBlockList, Double> SMOKE_POS;
    private FireBlockList baseFireBlock;

    private static Block.Properties createProps() {
        Block.Properties p = Block.Properties.func_200945_a((Material)Material.field_151594_q);
        p.func_200951_a(15);
        p.func_200943_b(0.0f);
        p.func_200942_a();
        p.func_200947_a(new SoundType(0.5f, 2.0f, SoundEvents.field_187546_ae, SoundEvents.field_187554_ai, SoundEvents.field_187845_fY, SoundEvents.field_187550_ag, SoundEvents.field_187548_af));
        return p;
    }

    public Fire(FireBlockList _baseFireBlock) {
        super("fire_for_" + (Object)((Object)_baseFireBlock), null, Fire.createProps(), SHAPES.get((Object)_baseFireBlock));
        this.baseFireBlock = _baseFireBlock;
    }

    @Override
    public void init() {
        this.setRegistryName(this.name);
        this.blockItem = new BlockItem((Block)this, AdditionalLights.ItemProps);
        this.blockItem.setRegistryName(this.getRegistryName());
    }

    protected float getFireDamageAmount() {
        return 0.0f;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get((Object)this.baseFireBlock);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + SMOKE_POS.get((Object)this.baseFireBlock);
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_195594_a((IParticleData)PARTICLE_TYPES.get((Object)this.baseFireBlock), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        return list;
    }

    static {
        SHAPES.put(FireBlockList.standing_torch_s, Block.func_208617_a((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0));
        SHAPES.put(FireBlockList.standing_torch_l, Block.func_208617_a((double)4.0, (double)-2.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0));
        SHAPES.put(FireBlockList.fire_pit_s, Block.func_208617_a((double)0.0, (double)-10.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        SHAPES.put(FireBlockList.fire_pit_l, Block.func_208617_a((double)0.0, (double)-2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
        PARTICLE_TYPES = new LinkedHashMap<FireBlockList, BasicParticleType>();
        PARTICLE_TYPES.put(FireBlockList.standing_torch_s, ParticleTypes.field_197601_L);
        PARTICLE_TYPES.put(FireBlockList.standing_torch_l, ParticleTypes.field_197601_L);
        PARTICLE_TYPES.put(FireBlockList.fire_pit_s, ParticleTypes.field_197594_E);
        PARTICLE_TYPES.put(FireBlockList.fire_pit_l, ParticleTypes.field_197594_E);
        SMOKE_POS = new LinkedHashMap<FireBlockList, Double>();
        SMOKE_POS.put(FireBlockList.standing_torch_s, 0.2);
        SMOKE_POS.put(FireBlockList.standing_torch_l, 0.7);
        SMOKE_POS.put(FireBlockList.fire_pit_s, 0.0);
        SMOKE_POS.put(FireBlockList.fire_pit_l, 0.8);
    }
}

