/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.blocks.IModBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.storage.loot.LootContext;

public abstract class ModBlock
extends Block
implements IModBlock {
    protected BlockItem blockItem;
    protected String name;
    private VoxelShape voxelShape;
    private BlockRenderLayer blockRenderLayer;

    public ModBlock(String basename, Block mainblock, Block.Properties props, VoxelShape shape) {
        super(props);
        this.name = mainblock == null ? basename : basename + mainblock.getRegistryName().func_110623_a();
        this.voxelShape = shape;
        this.blockRenderLayer = this.name.contains("glass") ? BlockRenderLayer.CUTOUT : BlockRenderLayer.SOLID;
    }

    @Override
    public void init() {
        this.setRegistryName(this.name);
        this.blockItem = new BlockItem((Block)this, AdditionalLights.ItemProps);
        this.blockItem.setRegistryName(this.getRegistryName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BlockItem getBlockItem() {
        return this.blockItem;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.voxelShape;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return this.blockRenderLayer;
    }

    protected static Block.Properties createBasicProps(Block mainblock) {
        Block.Properties p = Block.Properties.func_200945_a((Material)mainblock.func_149688_o(null));
        p.harvestTool(mainblock.getHarvestTool(null));
        p.harvestLevel(mainblock.getHarvestLevel(null));
        p.func_200948_a(mainblock.func_176195_g(null, null, null), mainblock.func_149638_a());
        p.func_200947_a(mainblock.getSoundType(null, null, null, null));
        return p;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((IItemProvider)this.blockItem));
        return list;
    }
}

