/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum Arrows {
    OVERHEAD(0.0, 1),
    UNDERFOOT(180.0, -1);

    private final CommonMath.Angle angle;
    public final int step;

    private Arrows(double degrees, int step) {
        this.angle = CommonMath.Angle.fromDegrees((double)degrees);
        this.step = step;
    }

    public Arrow create(ColorARGB color, TargetLocation location) {
        return new Arrow(color, location, this.angle);
    }

    class Arrow
    extends Indicator {
        private static final float SIZE = 0.2f;
        private final CommonMath.Angle angle;

        public Arrow(ColorARGB color, TargetLocation location, CommonMath.Angle angle) {
            super(color, location);
            this.angle = angle;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void draw(IVertexBuilder builder, MatrixStack matrix, float scale) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)this.angle.getRadians()));
            float size = 0.2f * scale;
            this.addVertex(builder, matrix, 0.0f, size, 0.5f, 0.0f);
            this.addVertex(builder, matrix, -size, size / 2.0f, 0.0f, 1.0f);
            this.addVertex(builder, matrix, size, size / 2.0f, 1.0f, 1.0f);
            this.addVertex(builder, matrix, size, size / 2.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
        }
    }
}

