/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonTime;
import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.core.ForgeThread;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.AdFinders;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FinderState {
    private final Finder finder;
    private Entity carrier;
    private CommonTime.Stamp lastUpdate;
    private BlockPos lastPosition;
    private boolean depositFound;
    private Searcher searcher;
    private Map<Arrows, Arrows.Arrow> arrows = Collections.synchronizedMap(new EnumMap(Arrows.class));
    private List<Needle> needles = Collections.synchronizedList(new ArrayList());

    public FinderState(Finder finder, Entity carrier) {
        this.finder = finder;
        this.carrier = carrier;
    }

    @Nullable
    protected CommonTime.Stamp getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    protected BlockPos getLastPos() {
        return this.lastPosition;
    }

    public Entity getCarrier() {
        return this.carrier;
    }

    public int getNeedlesCount() {
        return this.needles.size();
    }

    public int getTargetsCount() {
        return this.getNeedlesCount() + this.arrows.size();
    }

    public List<Needle> getNeedles() {
        return Collections.unmodifiableList(this.needles);
    }

    public Map<Arrows, Arrows.Arrow> getArrows() {
        return Collections.unmodifiableMap(this.arrows);
    }

    public boolean isDepositFound() {
        return this.depositFound;
    }

    public boolean isActual() {
        return this.getLastUpdate() == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.getLastUpdate()).lessThan(Finder.STATE_TTL);
    }

    public boolean needsUpdate() {
        boolean isUpdateTime = this.getLastUpdate() == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.getLastUpdate()).moreThan(Finder.UPDATE_INTERVAL);
        boolean entityMoved = !this.getCarrier().func_233580_cy_().equals((Object)this.getLastPos());
        return isUpdateTime || entityMoved;
    }

    public void update(Entity carrier) {
        this.setCarrier(carrier);
        if (this.searcher == null || !this.searcher.isAlive()) {
            this.searcher = new Searcher();
        }
        this.lastPosition = this.getCarrier().func_233580_cy_();
        this.lastUpdate = CommonTime.Stamp.now();
    }

    public Finder getFinder() {
        return this.finder;
    }

    protected void setCarrier(Entity carrier) {
        this.carrier = carrier;
    }

    public static class UpdateMsg
    extends ForgeNetMsg<UpdateMsg> {
        public int livingId;
        public Hand hand;

        public UpdateMsg() {
        }

        public UpdateMsg(LivingEntity living, Hand hand) {
            this.livingId = living.func_145782_y();
            this.hand = hand;
        }

        public UpdateMsg create() {
            return new UpdateMsg();
        }

        public void handle(World world, PlayerEntity player) {
            LivingEntity living;
            ItemStack stack;
            Entity entity = world.func_73045_a(this.livingId);
            if (entity instanceof LivingEntity && Finder.stackHasFinder(stack = (living = (LivingEntity)entity).func_184586_b(this.hand))) {
                Finder finder = Finder.getFinderItem(stack);
                if (GameWorld.isServerSide((IWorldReader)world)) {
                    AdFinders.getInstance().getConnection().sendToAllAround((Object)this, (IWorldReader)entity.func_130014_f_(), entity.func_233580_cy_(), Finder.SEARCH_BOUNDS.getMax().intValue());
                } else {
                    finder.updateState(stack, (Entity)living, this.hand);
                }
            }
        }
    }

    protected class Searcher
    extends ForgeThread {
        private final Map<TargetLocation, Target> foundTargets = new ConcurrentHashMap<TargetLocation, Target>();

        public Searcher() {
            this.start();
        }

        public IntBounds getStartY() {
            int height = (int)FinderState.this.getCarrier().func_213302_cg();
            if ((float)height == FinderState.this.getCarrier().func_213302_cg()) {
                --height;
            }
            int minY = FinderState.this.getCarrier().func_233580_cy_().func_177956_o();
            int maxY = minY + height;
            return new IntBounds(Integer.valueOf(minY), Integer.valueOf(maxY));
        }

        public int getStartX() {
            return MathHelper.func_76128_c((double)FinderState.this.getCarrier().func_226277_ct_());
        }

        public int getStartZ() {
            return MathHelper.func_76128_c((double)FinderState.this.getCarrier().func_226281_cx_());
        }

        public World getWorld() {
            return FinderState.this.getCarrier().func_130014_f_();
        }

        public void run() {
            this.searchVeins();
            this.searchTargetsAround();
            this.searchDeposit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchVeins() {
            EnumMap<Arrows, Arrows.Arrow> updatedArrows = new EnumMap<Arrows, Arrows.Arrow>(Arrows.class);
            Finder finder = FinderState.this.getFinder();
            IntBounds pingBounds = this.getStartY().extend(Integer.valueOf(finder.getPingDepth()));
            IntBounds boundsY = pingBounds.fit((IBounds)GameBounds.HEIGHT.getIntBounds());
            block3: for (Arrows arrow : Arrows.values()) {
                int startY;
                BlockState lastState = Blocks.field_150350_a.func_176223_P();
                int y = startY = (arrow == Arrows.OVERHEAD ? this.getStartY().getMax() : this.getStartY().getMin()).intValue();
                while (boundsY.encloses(Integer.valueOf(y))) {
                    int veinSize = 0;
                    Target foundTarget = null;
                    BlockPos pos = new BlockPos(this.getStartX(), y, this.getStartZ());
                    BlockState state = this.getWorld().func_180495_p(pos);
                    if (state != lastState && state.func_185904_a() != Material.field_151579_a) {
                        lastState = state;
                        for (Target target : FinderState.this.getFinder().getAllTargets()) {
                            if (!target.matches(state)) continue;
                            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                            veinSize = this.countNeighbours(target, pos, finder.getVeinMinSize(), posList);
                            if (veinSize < finder.getVeinMinSize()) continue;
                            foundTarget = target;
                            break;
                        }
                    }
                    if (foundTarget != null) {
                        int distance = Math.abs(y - startY);
                        TargetLocation location = TargetLocation.from(pos, distance);
                        updatedArrows.put(arrow, arrow.create(foundTarget.getColor(), location));
                        this.foundTargets.put(location, foundTarget);
                        continue block3;
                    }
                    y += arrow.step;
                }
            }
            Map map = FinderState.this.arrows;
            synchronized (map) {
                FinderState.this.arrows = updatedArrows;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchTargetsAround() {
            ArrayList<Needle> updatedNeedles = new ArrayList<Needle>();
            Finder finder = FinderState.this.getFinder();
            Vect3d finderPos = ForgeEntity.getCenterPosition((Entity)FinderState.this.getCarrier());
            IntBounds scanVertBounds = this.getStartY().extend(Integer.valueOf(2));
            IntBounds rangeY = scanVertBounds.fit((IBounds)GameBounds.HEIGHT.getIntBounds());
            IntBounds rangeX = new IntBounds(Integer.valueOf(this.getStartX())).extend(Integer.valueOf(finder.getScanRadius()));
            IntBounds rangeZ = new IntBounds(Integer.valueOf(this.getStartZ())).extend(Integer.valueOf(finder.getScanRadius()));
            for (List<Target> group : FinderState.this.getFinder().getTargetGroups().values()) {
                Target nearestTarget = null;
                BlockPos nearestPos = null;
                double minDistance = Double.MAX_VALUE;
                for (int y = rangeY.getMin().intValue(); y <= rangeY.getMax(); ++y) {
                    for (int z = rangeZ.getMin().intValue(); z <= rangeZ.getMax(); ++z) {
                        for (int x = rangeX.getMin().intValue(); x <= rangeX.getMax(); ++x) {
                            BlockPos pos = new BlockPos(x, y, z);
                            BlockState state = this.getWorld().func_180495_p(pos);
                            for (Target target : group) {
                                double lastDistance;
                                if (!target.matches(state) || !((lastDistance = finderPos.distance(GameWorld.getBlockCenter((BlockPos)pos))) < minDistance)) continue;
                                nearestPos = pos;
                                nearestTarget = target;
                                minDistance = lastDistance;
                            }
                        }
                    }
                }
                if (nearestTarget == null || nearestPos == null) continue;
                TargetLocation location = TargetLocation.from(nearestPos, minDistance);
                updatedNeedles.add(new Needle(nearestTarget.getColor(), location));
                this.foundTargets.put(location, nearestTarget);
            }
            Collections.sort(updatedNeedles, Needle.SORTING_COMPARATOR);
            List list = FinderState.this.needles;
            synchronized (list) {
                FinderState.this.needles = updatedNeedles;
            }
        }

        private void searchDeposit() {
            int minSize = FinderState.this.getFinder().getDepositMinSize();
            for (Map.Entry<TargetLocation, Target> entry : this.foundTargets.entrySet()) {
                ArrayList<BlockPos> posList;
                BlockPos pos;
                Target target = entry.getValue();
                int size = this.countNeighbours(target, pos = entry.getKey().getPos(), minSize, posList = new ArrayList<BlockPos>());
                if (size < minSize) continue;
                FinderState.this.depositFound = true;
                return;
            }
            FinderState.this.depositFound = false;
        }

        private int countNeighbours(Target target, BlockPos startPos, int maxNeighbours, List<BlockPos> foundList) {
            int count = 1;
            foundList.add(startPos);
            for (Direction facing : Direction.values()) {
                if (count >= maxNeighbours) break;
                BlockPos pos = startPos.func_177972_a(facing);
                if (!target.matches(this.getWorld().func_180495_p(pos)) || foundList.contains(pos)) continue;
                count += this.countNeighbours(target, pos, maxNeighbours - count, foundList);
            }
            return count;
        }
    }

    public static class SharedData {
        public final int scanRadius;
        public final int pingDepth;
        public final int veinMinSize;
        public final int depositMinSize;

        public SharedData(int scanRadius, int pingDepth, int veinMinSize, int depositMinSize) {
            this.scanRadius = scanRadius;
            this.pingDepth = pingDepth;
            this.veinMinSize = veinMinSize;
            this.depositMinSize = depositMinSize;
        }
    }
}

