/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.ModEntities;
import animalium.ModItems;
import animalium.configs.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class EntityRat
extends MonsterEntity {
    private AttackGoal aiAttack;
    private AvoidEntityGoal<LivingEntity> aiRunAway;
    private NearestAttackableTargetGoal<PlayerEntity> aiTarget;
    private static final DataParameter<Boolean> CAN_ATTACK = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityRat(EntityType<? extends EntityRat> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CAN_ATTACK, (Object)false);
    }

    public boolean getCanAttack() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_ATTACK);
    }

    private void setCanAttack(boolean canAttack) {
        this.field_70180_af.func_187227_b(CAN_ATTACK, (Object)canAttack);
    }

    protected void func_184651_r() {
        this.aiAttack = new AttackGoal(this);
        this.aiRunAway = new AvoidEntityGoal((CreatureEntity)this, LivingEntity.class, 10.0f, 0.6, 0.6);
        this.aiTarget = new TargetGoal<PlayerEntity>(this, PlayerEntity.class);
        this.field_70714_bg.func_75776_a(0, (Goal)this.aiAttack);
        this.field_70714_bg.func_75776_a(1, this.aiRunAway);
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.65));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, this.aiTarget);
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (((Boolean)Config.RAT_ATTACK_MOBS.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(1, new TargetGoal<MonsterEntity>(this, MonsterEntity.class));
        }
        if (((Boolean)Config.RAT_ATTACK_CREATURES.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(2, new TargetGoal<LivingEntity>(this, LivingEntity.class));
        }
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, (double)0.65f).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && !this.getCanAttack()) {
                this.field_70714_bg.func_85156_a(this.aiRunAway);
                this.field_70714_bg.func_75776_a(0, (Goal)this.aiAttack);
                this.field_70715_bh.func_75776_a(0, this.aiTarget);
                this.setCanAttack(true);
            }
            if (!this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.getCanAttack()) {
                this.field_70714_bg.func_85156_a((Goal)this.aiAttack);
                this.field_70715_bh.func_85156_a(this.aiTarget);
                this.field_70714_bg.func_75776_a(1, this.aiRunAway);
                this.setCanAttack(false);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            boolean attacked = super.func_70652_k(entity);
            if (attacked && entity instanceof PlayerEntity && this.func_70681_au().nextInt((Integer)Config.RAT_STEALS_PROBABILITY.get()) == 0 && ((Boolean)Config.RAT_STEALS_ITEMS.get()).booleanValue()) {
                ItemStack stack;
                PlayerEntity player = (PlayerEntity)entity;
                if (!this.func_130014_f_().field_72995_K && this.getCanAttack() && !(stack = player.func_184614_ca()).func_190926_b()) {
                    ItemStack stack2 = stack.func_77946_l();
                    if (stack.func_77942_o()) {
                        stack2.func_77982_d(stack.func_77978_p());
                    }
                    stack2.func_77979_a(stack.func_190916_E() - 1);
                    this.func_184201_a(EquipmentSlotType.MAINHAND, stack2);
                    this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
            }
            return attacked;
        }
        return false;
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return typeIn != ModEntities.RAT;
    }

    public static boolean isValidLightLevel(IWorld world, BlockPos pos) {
        return world.func_226658_a_(LightType.BLOCK, pos) < 8;
    }

    public static boolean canSpawnHere(EntityType<EntityRat> entity, IWorld world, SpawnReason spawn_reason, BlockPos pos, Random random) {
        if (EntityRat.isDimBlacklisted(EntityRat.getDimensionRegName((RegistryKey<World>)world.func_201672_e().func_234923_W_()))) {
            return false;
        }
        return world.func_175659_aa() != Difficulty.PEACEFUL && EntityRat.isValidLightLevel(world, pos) && pos.func_177956_o() <= (Integer)Config.RAT_SPAWN_Y_HEIGHT.get();
    }

    public static boolean isDimBlacklisted(String dimensionIn) {
        return ((List)Config.RAT_BLACKLISTED_DIMS.get()).contains(dimensionIn);
    }

    public static String getDimensionRegName(RegistryKey<World> reg) {
        return reg.func_240901_a_().toString();
    }

    public boolean func_205019_a(IWorldReader world) {
        return !world.func_72953_d(this.func_174813_aQ()) && world.func_226668_i_((Entity)this);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        ItemStack stack;
        if (!this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
            stack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            this.func_70099_a(stack, 1.0f);
        }
        if (this.func_130014_f_().field_73012_v.nextInt(5) == 0) {
            stack = new ItemStack((IItemProvider)ModItems.RAT_MEAT);
            if (this.func_70027_ad()) {
                stack = new ItemStack((IItemProvider)ModItems.RAT_MEAT_COOKED);
            }
            this.func_70099_a(stack, 1.0f);
        }
    }

    protected float func_70647_i() {
        return 0.5f;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        private final EntityRat rat;

        public AttackGoal(EntityRat rat) {
            super((CreatureEntity)rat, 0.6, false);
            this.rat = rat;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.rat.getCanAttack();
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0 || !this.rat.getCanAttack()) {
                this.field_75441_b.func_70624_b((LivingEntity)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(EntityRat rat, Class<T> classTarget) {
            super((MobEntity)rat, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }
}

