/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossFeature;
import shadows.apotheosis.deadly.gen.BrutalSpawner;
import shadows.apotheosis.deadly.gen.SwarmSpawner;
import shadows.apotheosis.deadly.gen.WorldFeature;

public class WorldGenerator
extends Feature<NoFeatureConfig> {
    public static final List<WorldFeature> FEATURES = new ArrayList<WorldFeature>();
    public static final BrutalSpawner BRUTAL_SPAWNER = new BrutalSpawner();
    public static final BossFeature BOSS_GENERATOR = new BossFeature();
    public static final SwarmSpawner SWARM_SPAWNER = new SwarmSpawner();
    private static final Map<ResourceLocation, LongSet> SUCCESSES = new HashMap<ResourceLocation, LongSet>();
    public static final Predicate<BlockState> STONE_TEST = OreFeatureConfig.FillerBlockType.NATURAL_STONE.func_214738_b();
    public static final boolean DEBUG = false;

    public WorldGenerator() {
        super(NoFeatureConfig::func_214639_a);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (DeadlyConfig.DIM_WHITELIST.contains(world.func_201675_m().func_186058_p().getRegistryName())) {
            for (WorldFeature feature : FEATURES) {
                ChunkPos cPos = new ChunkPos(pos);
                if (WorldGenerator.wasSuccess(world.func_201675_m().func_186058_p().getRegistryName(), cPos.field_77276_a, cPos.field_77275_b)) {
                    return false;
                }
                if (!feature.generate(world, cPos.field_77276_a, cPos.field_77275_b, rand)) continue;
                return true;
            }
        }
        return false;
    }

    public static void init() {
        if (BRUTAL_SPAWNER.isEnabled()) {
            FEATURES.add(BRUTAL_SPAWNER);
        }
        if (SWARM_SPAWNER.isEnabled()) {
            FEATURES.add(SWARM_SPAWNER);
        }
        if (BOSS_GENERATOR.isEnabled()) {
            FEATURES.add(BOSS_GENERATOR);
        }
        ConfiguredFeature gen = new ConfiguredFeature(ApotheosisObjects.DEADLY_WORLD_GEN, (IFeatureConfig)IFeatureConfig.field_202429_e);
        DeferredWorkQueue.runLater(() -> {
            for (Biome b : ForgeRegistries.BIOMES) {
                if (DeadlyConfig.BIOME_BLACKLIST.contains(b.getRegistryName())) continue;
                b.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, gen);
            }
        });
    }

    public static void debugPillar(World world, BlockPos pos) {
        BlockPos.Mutable mPos = new BlockPos.Mutable(pos);
        DeadlyModule.LOGGER.info("Marking! " + pos.toString());
        while (mPos.func_177956_o() < 127) {
            world.func_175656_a((BlockPos)mPos.func_181079_c(mPos.func_177958_n(), mPos.func_177956_o() + 1, mPos.func_177952_p()), Blocks.field_150359_w.func_176223_P());
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }

    public static void setSuccess(ResourceLocation dim, int x, int z) {
        SUCCESSES.computeIfAbsent(dim, i -> new LongOpenHashSet()).add(ChunkPos.func_77272_a((int)x, (int)z));
    }

    public static boolean wasSuccess(ResourceLocation dim, int x, int z) {
        return SUCCESSES.computeIfAbsent(dim, i -> new LongOpenHashSet()).contains(ChunkPos.func_77272_a((int)x, (int)z));
    }
}

