/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.loot.EquipmentType;
import shadows.apotheosis.deadly.loot.LootEntry;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.deadly.loot.affix.Affixes;
import shadows.apotheosis.deadly.loot.modifiers.AffixModifier;
import shadows.apotheosis.deadly.loot.modifiers.Modifiers;

public class LootManager
extends JsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(LootEntry.class, (json, type, ctx) -> LootEntry.deserialize(json.getAsJsonObject())).setPrettyPrinting().create();
    public static final LootManager INSTANCE = new LootManager();
    private static final List<LootEntry> ENTRIES = new ArrayList<LootEntry>();

    private LootManager() {
        super(GSON, "affix_loot_entries");
    }

    protected void apply(Map<ResourceLocation, JsonObject> objects, IResourceManager mgr, IProfiler profiler) {
        ENTRIES.clear();
        for (Map.Entry<ResourceLocation, JsonObject> obj : objects.entrySet()) {
            try {
                LootEntry ent = (LootEntry)((Object)GSON.fromJson((JsonElement)obj.getValue(), LootEntry.class));
                ENTRIES.add(ent);
            }
            catch (Exception e) {
                DeadlyModule.LOGGER.error("Failed to load affix loot entry {}.", (Object)obj.getKey());
                e.printStackTrace();
            }
        }
        DeadlyModule.LOGGER.info("Loaded {} affix loot entries from resources.", (Object)ENTRIES.size());
    }

    public static List<LootEntry> getEntries() {
        return ENTRIES;
    }

    public static ItemStack getRandomEntry(Random rand, LootRarity rarity) {
        LootEntry entry = (LootEntry)WeightedRandom.func_76271_a((Random)rand, ENTRIES);
        ItemStack stack = rarity == LootRarity.ANCIENT ? LootManager.genUnique(rand) : entry.getStack().func_77946_l();
        return stack;
    }

    public static ItemStack genLootItem(ItemStack stack, Random rand, LootRarity rarity) {
        ITextComponent name = stack.func_200301_q();
        EquipmentType type = EquipmentType.getTypeFor(stack);
        HashMap<WeightedRandom.Item, AffixModifier> affixes = new HashMap<WeightedRandom.Item, AffixModifier>();
        EquipmentSlotType slot = EquipmentType.getTypeFor(stack).getSlot(stack);
        Multimap modifs = stack.func_111283_C(slot);
        AffixHelper.setRarity(stack, rarity);
        modifs.forEach((s, a) -> stack.func_185129_a(s, a, slot));
        if (type == EquipmentType.AXE) {
            AffixHelper.applyAffix(stack, Affixes.PIERCING, Affixes.PIERCING.apply(stack, rand, null));
        }
        List<Affix> afxList = AffixHelper.getAffixesFor(type);
        int affixCount = rarity.getAffixes();
        while (affixes.size() < Math.min(affixCount, afxList.size())) {
            affixes.put(WeightedRandom.func_76271_a((Random)rand, afxList), rarity == LootRarity.COMMON ? (rand.nextBoolean() ? Modifiers.MIN : Modifiers.HALF) : null);
        }
        if (rarity.ordinal() >= LootRarity.EPIC.ordinal()) {
            float modifChance = rarity == LootRarity.EPIC ? 0.3f : 0.65f;
            for (Affix a2 : affixes.keySet()) {
                if (!(rand.nextFloat() <= modifChance)) continue;
                affixes.put(a2, Modifiers.getRandomModifier(rand));
            }
        }
        for (Affix a3 : affixes.keySet()) {
            name = a3.chainName(name, (AffixModifier)((Object)affixes.get((Object)a3)));
            AffixHelper.applyAffix(stack, a3, a3.apply(stack, rand, (AffixModifier)((Object)affixes.get((Object)a3))));
        }
        if (rarity.ordinal() >= LootRarity.MYTHIC.ordinal()) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74757_a("Unbreakable", true);
        }
        stack.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + rarity.getColor().toString() + name.func_150254_d().replace(TextFormatting.RESET.toString(), "")));
        return stack;
    }

    public static ItemStack genUnique(Random rand) {
        return ItemStack.field_190927_a;
    }
}

