/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossItem;
import shadows.apotheosis.deadly.loot.LootEntry;
import shadows.apotheosis.deadly.loot.LootManager;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.affix.AffixHelper;
import shadows.apotheosis.deadly.loot.affix.AffixTrade;
import shadows.apotheosis.deadly.loot.affix.Affixes;

public class AffixEvents {
    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e) {
        AbstractArrowEntity ent;
        Entity shooter;
        if (e.getEntity() instanceof AbstractArrowEntity && !e.getEntity().getPersistentData().func_74767_n("apoth.generated") && (shooter = (ent = (AbstractArrowEntity)e.getEntity()).func_212360_k()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)shooter;
            ItemStack bow = living.func_184614_ca();
            Map<Affix, Float> affixes = AffixHelper.getAffixes(bow);
            CompoundNBT nbt = new CompoundNBT();
            affixes.keySet().forEach(a -> {
                a.onArrowFired(living, ent, bow, ((Float)affixes.get(a)).floatValue());
                nbt.func_74776_a(a.getRegistryName().toString(), ((Float)affixes.get(a)).floatValue());
            });
            ent.getPersistentData().func_218657_a("apoth.affixes", (INBT)nbt);
        }
    }

    @SubscribeEvent
    public void impact(ProjectileImpactEvent.Arrow e) {
        CompoundNBT nbt = e.getArrow().getPersistentData().func_74775_l("apoth.affixes");
        for (String s : nbt.func_150296_c()) {
            Affix a = (Affix)Affix.REGISTRY.getValue(new ResourceLocation(s));
            a.onArrowImpact(e.getArrow(), e.getRayTraceResult(), e.getRayTraceResult().func_216346_c(), nbt.func_74760_g(s));
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent e) {
        Object affixes;
        if (e.getSource() instanceof IndirectEntityDamageSource) {
            IndirectEntityDamageSource src = (IndirectEntityDamageSource)e.getSource();
            if ("arrow".equals(src.field_76373_n) && (affixes = src.func_76364_f().getPersistentData().func_74775_l("apoth.affixes")).func_74764_b(Affixes.MAGIC_ARROW.getRegistryName().toString())) {
                e.setCanceled(true);
                DamageSource nSrc = new IndirectEntityDamageSource("apoth.magic_arrow", src.func_76364_f(), src.func_76346_g()).func_76348_h().func_82726_p().func_76349_b();
                e.getEntityLiving().field_70172_ad = 0;
                e.getEntityLiving().func_70097_a(nSrc, e.getAmount());
            }
        }
        if (e.getSource() instanceof EntityDamageSource && e.getSource().func_76346_g() instanceof PlayerEntity) {
            float overheal;
            PlayerEntity player = (PlayerEntity)e.getSource().func_76346_g();
            affixes = AffixHelper.getAffixes(player.func_184614_ca());
            float lifeSteal = affixes.getOrDefault((Object)Affixes.LIFE_STEAL, Float.valueOf(0.0f)).floatValue();
            if (lifeSteal > 0.0f && !e.getSource().func_82725_o()) {
                player.func_70691_i(e.getAmount() * lifeSteal);
            }
            if ((overheal = affixes.getOrDefault((Object)Affixes.OVERHEAL, Float.valueOf(0.0f)).floatValue()) > 0.0f && !e.getSource().func_82725_o() && player.func_110139_bj() < 20.0f) {
                player.func_110149_m(Math.min(20.0f, player.func_110139_bj() + e.getAmount() * overheal));
            }
            if (affixes.containsKey((Object)Affixes.PIERCING)) {
                e.getSource().func_76348_h();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void drops(LivingDropsEvent e) {
        IndirectEntityDamageSource src;
        if (e.getSource() instanceof IndirectEntityDamageSource && (src = (IndirectEntityDamageSource)e.getSource()).func_76364_f() instanceof AbstractArrowEntity && src.func_76346_g() != null) {
            CompoundNBT affixes = src.func_76364_f().getPersistentData().func_74775_l("apoth.affixes");
            int canTeleport = (int)affixes.func_74760_g(Affixes.TELEPORT_DROPS.getRegistryName().toString());
            for (ItemEntity item : e.getDrops()) {
                if (canTeleport <= 0) continue;
                Entity tSrc = src.func_76346_g();
                item.func_70107_b(tSrc.func_226277_ct_(), tSrc.func_226278_cu_(), tSrc.func_226281_cx_());
                --canTeleport;
            }
        }
        if (e.getSource().func_76346_g() instanceof PlayerEntity && !e.getDrops().isEmpty() && e.getEntityLiving().func_184222_aU()) {
            LivingEntity dead = e.getEntityLiving();
            PlayerEntity player = (PlayerEntity)e.getSource().func_76346_g();
            float chance = AffixHelper.getAffixes(player.func_184614_ca()).getOrDefault((Object)Affixes.LOOT_PINATA, Float.valueOf(0.0f)).floatValue();
            if (player.field_70170_p.field_73012_v.nextFloat() < chance) {
                player.field_70170_p.func_184148_a(null, dead.func_226277_ct_(), dead.func_226278_cu_(), dead.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197626_s, dead.func_226277_ct_(), dead.func_226278_cu_(), dead.func_226281_cx_(), 2, 1.0, 0.0, 0.0, 0.0);
                ArrayList drops = new ArrayList(e.getDrops());
                for (int i = 0; i < 20; ++i) {
                    for (ItemEntity item : drops) {
                        e.getDrops().add(new ItemEntity(player.field_70170_p, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), item.func_92059_d().func_77946_l()));
                    }
                }
                for (ItemEntity item : e.getDrops()) {
                    if (item.func_92059_d().func_77973_b().func_77645_m()) continue;
                    item.func_70107_b(dead.func_226277_ct_(), dead.func_226278_cu_(), dead.func_226281_cx_());
                    item.func_213293_j(-0.3 + dead.field_70170_p.field_73012_v.nextDouble() * 0.6, 0.3 + dead.field_70170_p.field_73012_v.nextDouble() * 0.3, -0.3 + dead.field_70170_p.field_73012_v.nextDouble() * 0.6);
                }
            }
        }
    }

    @SubscribeEvent
    public void update(LivingEntityUseItemEvent.Tick e) {
        ItemStack stack;
        Map<Affix, Float> affixes;
        if (e.getEntity() instanceof PlayerEntity && (affixes = AffixHelper.getAffixes(stack = e.getItem())).containsKey((Object)Affixes.DRAW_SPEED)) {
            for (float t = affixes.get((Object)Affixes.DRAW_SPEED).floatValue(); t > 0.0f; t -= 1.0f) {
                if (e.getEntity().field_70173_aa % (int)Math.floor(1.0f / Math.min(1.0f, t)) != 0) continue;
                e.setDuration(e.getDuration() - 1);
            }
        }
    }

    @SubscribeEvent
    public void crit(CriticalHitEvent e) {
        Map<Affix, Float> affixes = AffixHelper.getAffixes(e.getPlayer().func_184614_ca());
        if (!e.isVanillaCritical() && e.getPlayer().field_70170_p.field_73012_v.nextFloat() < affixes.getOrDefault((Object)Affixes.CRIT_CHANCE, Float.valueOf(0.0f)).floatValue()) {
            e.setResult(Event.Result.ALLOW);
        }
        if (!e.isVanillaCritical() && affixes.containsKey((Object)Affixes.MAX_CRIT)) {
            e.setResult(Event.Result.ALLOW);
        }
        if (affixes.containsKey((Object)Affixes.CRIT_DAMAGE)) {
            e.setDamageModifier((1.0f + affixes.get((Object)Affixes.CRIT_DAMAGE).floatValue()) * Math.max(1.5f, e.getDamageModifier()));
        }
    }

    @SubscribeEvent
    public void starting(FMLServerStartingEvent e) {
        e.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"affixloot").requires(c -> c.func_197034_c(2))).then(Commands.func_197056_a((String)"rarity", (ArgumentType)StringArgumentType.word()).suggests((a, b) -> ISuggestionProvider.func_197005_b((Iterable)Arrays.stream(LootRarity.values()).map(r -> r.toString()).collect(Collectors.toList()), (SuggestionsBuilder)b)).executes(c -> {
            ServerPlayerEntity p = ((CommandSource)c.getSource()).func_197035_h();
            p.func_191521_c(LootManager.genLootItem(LootManager.getRandomEntry(p.field_70170_p.field_73012_v, null), p.field_70170_p.field_73012_v, LootRarity.valueOf((String)c.getArgument("rarity", String.class))));
            return 0;
        })));
    }

    public static ActionResultType onItemUse(ItemUseContext ctx) {
        ItemStack s = ctx.func_195996_i();
        if (!s.func_190926_b()) {
            Map<Affix, Float> affixes = AffixHelper.getAffixes(s);
            for (Map.Entry<Affix, Float> ent : affixes.entrySet()) {
                ActionResultType type = ent.getKey().onItemUse(ctx, ent.getValue().floatValue());
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck e) {
        Map<Affix, Float> affixes;
        ItemStack stack = e.getPlayer().func_184614_ca();
        if (!stack.func_190926_b() && (affixes = AffixHelper.getAffixes(stack)).containsKey((Object)Affixes.OMNITOOL) && (Items.field_151046_w.func_150897_b(e.getTargetBlock()) || Items.field_151047_v.func_150897_b(e.getTargetBlock()) || Items.field_151056_x.func_150897_b(e.getTargetBlock()))) {
            e.setCanHarvest(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void speed(PlayerEvent.BreakSpeed e) {
        Map<Affix, Float> affixes;
        ItemStack stack = e.getPlayer().func_184614_ca();
        if (!stack.func_190926_b() && (affixes = AffixHelper.getAffixes(stack)).containsKey((Object)Affixes.OMNITOOL)) {
            float shovel = AffixEvents.getBaseSpeed(e.getPlayer(), Items.field_151047_v, e.getState(), e.getPos());
            float axe = AffixEvents.getBaseSpeed(e.getPlayer(), Items.field_151056_x, e.getState(), e.getPos());
            float pickaxe = AffixEvents.getBaseSpeed(e.getPlayer(), Items.field_151046_w, e.getState(), e.getPos());
            e.setNewSpeed(Math.max(shovel, Math.max(axe, Math.max(pickaxe, e.getOriginalSpeed()))));
        }
    }

    static float getBaseSpeed(PlayerEntity player, Item tool, BlockState state, BlockPos pos) {
        float f = tool.func_150893_a(ItemStack.field_190927_a, state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.func_185293_e((LivingEntity)player);
            ItemStack itemstack = player.func_184614_ca();
            if (i > 0 && !itemstack.func_190926_b()) {
                f += (float)(i * i + 1);
            }
        }
        if (EffectUtils.func_205135_a((LivingEntity)player)) {
            f *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.func_70644_a(Effects.field_76419_f)) {
            float f1;
            switch (player.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (player.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)player)) {
            f /= 5.0f;
        }
        if (!player.field_70122_E) {
            f /= 5.0f;
        }
        return f;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void spawns(LivingSpawnEvent.SpecialSpawn e) {
        if (e.getSpawnReason() == SpawnReason.NATURAL || e.getSpawnReason() == SpawnReason.CHUNK_GENERATION) {
            LivingEntity entity = e.getEntityLiving();
            Random rand = e.getWorld().func_201674_k();
            if (!e.getWorld().func_201670_d() && entity instanceof MonsterEntity) {
                if (entity.func_184614_ca().func_190926_b() && rand.nextInt(DeadlyConfig.randomAffixItem) == 0) {
                    LootRarity rarity = LootRarity.random(rand);
                    LootEntry entry = (LootEntry)WeightedRandom.func_76271_a((Random)rand, LootManager.getEntries());
                    EquipmentSlotType slot = entry.getType().getSlot(entry.getStack());
                    ItemStack loot = LootManager.genLootItem(entry.getStack().func_77946_l(), rand, rarity);
                    loot.func_77978_p().func_74757_a("apoth_rspawn", true);
                    entity.func_184201_a(slot, loot);
                    ((MobEntity)entity).func_184642_a(slot, 2.0f);
                    return;
                }
                if (!e.getWorld().func_175710_j(new BlockPos((int)e.getX(), (int)e.getY() + 1, (int)e.getZ()))) {
                    return;
                }
                if (rand.nextInt(DeadlyConfig.surfaceBossChance) == 0) {
                    BossItem.initBoss(rand, (MobEntity)entity);
                    Vec3d pos = e.getEntity().func_213303_ch();
                    if (DeadlyConfig.surfaceBossLightning) {
                        ((ServerWorld)e.getWorld()).func_217468_a(new LightningBoltEntity((World)e.getWorld(), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), true));
                    }
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void trades(WandererTradesEvent e) {
        e.getRareTrades().add(new AffixTrade());
    }
}

