/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix.impl;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.RandomValueRange;
import shadows.apotheosis.deadly.loot.EquipmentType;
import shadows.apotheosis.deadly.loot.affix.Affix;
import shadows.apotheosis.deadly.loot.modifiers.AffixModifier;

public abstract class AttributeAffix
extends Affix {
    protected final IAttribute attr;
    protected final RandomValueRange range;
    protected final AttributeModifier.Operation op;

    public AttributeAffix(IAttribute attr, RandomValueRange range, AttributeModifier.Operation op, int weight) {
        super(weight);
        this.attr = attr;
        this.range = range;
        this.op = op;
    }

    public AttributeAffix(IAttribute attr, float min, float max, AttributeModifier.Operation op, int weight) {
        this(attr, new RandomValueRange(min, max), op, weight);
    }

    @Override
    public float apply(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        EquipmentSlotType type = EquipmentType.getTypeFor(stack).getSlot(stack);
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(this, lvl);
        }
        AttributeModifier modif = new AttributeModifier(this.getRegistryName() + "_" + this.attr.func_111108_a(), (double)lvl, this.op);
        stack.func_185129_a(this.attr.func_111108_a(), modif, type);
        return lvl;
    }

    @Override
    public float getMin() {
        return this.range.func_186509_a();
    }

    @Override
    public float getMax() {
        return this.range.func_186512_b();
    }
}

