/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.anvil;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BookItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.advancements.AdvancementTriggers;
import shadows.apotheosis.ench.anvil.TileAnvil;

public class BlockAnvilExt
extends AnvilBlock {
    public BlockAnvilExt() {
        super(Block.Properties.func_200949_a((Material)Material.field_151574_g, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAnvil();
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        ItemStack anvil = new ItemStack((IItemProvider)this);
        if (te instanceof TileAnvil) {
            TileAnvil anv = (TileAnvil)te;
            HashMap<Enchantment, Integer> ench = new HashMap<Enchantment, Integer>();
            if (anv.getUnbreaking() > 0) {
                ench.put(Enchantments.field_185307_s, anv.getUnbreaking());
            }
            if (anv.getSplitting() > 0) {
                ench.put(ApotheosisObjects.SPLITTING, anv.getSplitting());
            }
            EnchantmentHelper.func_82782_a(ench, (ItemStack)anvil);
        }
        BlockAnvilExt.func_180635_a((World)world, (BlockPos)pos, (ItemStack)anvil);
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAnvil) {
            ((TileAnvil)te).setUnbreaking(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack));
            ((TileAnvil)te).setSplitting(EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SPLITTING, (ItemStack)stack));
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77962_s()) {
            tooltip.add(new TranslationTextComponent("info.apotheosis.anvil", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    protected void func_149829_a(FallingBlockEntity e) {
        super.func_149829_a(e);
        TileEntity te = e.field_70170_p.func_175625_s(new BlockPos((Entity)e));
        e.field_145810_d = new CompoundNBT();
        if (te instanceof TileAnvil) {
            te.func_189515_b(e.field_145810_d);
        }
    }

    public void func_176502_a_(World world, BlockPos pos, BlockState fallState, BlockState hitState) {
        super.func_176502_a_(world, pos, fallState, hitState);
        List items = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
        FallingBlockEntity anvil = (FallingBlockEntity)world.func_217357_a(FallingBlockEntity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1))).get(0);
        if (anvil.field_145810_d == null) {
            return;
        }
        int split = anvil.field_145810_d.func_74762_e("splitting");
        int ub = anvil.field_145810_d.func_74762_e("ub");
        if (split > 0) {
            for (ItemEntity entity : items) {
                ItemStack stack = entity.func_92059_d();
                if (stack.func_77973_b() != Items.field_151134_bR && !(stack.func_77973_b() instanceof BookItem)) continue;
                if (world.field_73012_v.nextFloat() < 0.2f * (float)split) {
                    ListNBT enchants = EnchantedBookItem.func_92110_g((ItemStack)stack);
                    if (stack.func_77973_b() instanceof BookItem) {
                        enchants = stack.func_77986_q();
                    }
                    if (enchants.size() < 1) continue;
                    entity.func_70106_y();
                    for (INBT nbt : enchants) {
                        CompoundNBT tag = (CompoundNBT)nbt;
                        ItemStack book = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(tag.func_74779_i("id"))), tag.func_74762_e("lvl")));
                        Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)book);
                    }
                    world.func_175647_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_72314_b(5.0, 5.0, 5.0), EntityPredicates.field_180132_d).forEach(p -> AdvancementTriggers.SPLIT_BOOK.trigger(p.func_192039_O()));
                }
                if (world.field_73012_v.nextInt(1 + ub) != 0) break;
                BlockState dmg = BlockAnvilExt.func_196433_f((BlockState)fallState);
                if (dmg == null) {
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    world.func_217379_c(1029, pos, 0);
                    break;
                }
                world.func_175656_a(pos, dmg);
                break;
            }
        }
    }
}

