/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.objects;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.BookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import shadows.apotheosis.ench.EnchModule;

public class ItemTypedBook
extends BookItem {
    final ItemStack rep;
    final EnchantmentType type;

    public ItemTypedBook(Item rep, EnchantmentType type) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        this.type = type;
        this.rep = new ItemStack((IItemProvider)rep);
        this.setRegistryName("apotheosis", (type == null ? "null" : type.name().toLowerCase(Locale.ROOT)) + "_book");
        EnchModule.TYPED_BOOKS.add(this);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return stack.func_190916_E() == 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.type == null) {
            return EnchModule.TYPED_BOOKS.stream().filter(b -> b != this).allMatch(b -> !enchantment.func_92089_a(new ItemStack((IItemProvider)b)));
        }
        return enchantment.field_77351_y == this.type || enchantment.canApplyAtEnchantingTable(this.rep);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("info.apotheosis." + this.getRegistryName().func_110623_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return !stack.func_77948_v() ? super.func_77613_e(stack) : Rarity.UNCOMMON;
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack book = ev.getRight();
        ItemStack weapon = ev.getLeft();
        if (!(book.func_77973_b() instanceof BookItem && book.func_77948_v() && weapon.func_77973_b().func_77616_k(weapon))) {
            return false;
        }
        Map bookEnch = EnchantmentHelper.func_82781_a((ItemStack)book);
        Map wepEnch = EnchantmentHelper.func_82781_a((ItemStack)weapon);
        int cost = 0;
        for (Enchantment ench : bookEnch.keySet()) {
            int curLevel;
            if (ench == null) continue;
            int level = bookEnch.containsKey(ench) ? (Integer)bookEnch.get(ench) : 0;
            int n = curLevel = wepEnch.containsKey(ench) ? (Integer)wepEnch.get(ench) : 0;
            if (level > 0 && level == curLevel) {
                level = Math.min(EnchModule.getEnchInfo(ench).getMaxLevel(), level + 1);
            }
            if (curLevel > level) {
                level = curLevel;
            }
            if (!ench.func_92089_a(weapon)) continue;
            boolean isCompat = true;
            for (Enchantment ench2 : wepEnch.keySet()) {
                if (ench == ench2 || ench.func_191560_c(ench2)) continue;
                isCompat = false;
            }
            if (!isCompat) continue;
            wepEnch.put(ench, level);
            int addition = 0;
            switch (ench.func_77324_c()) {
                case COMMON: {
                    addition += 1 * level;
                    break;
                }
                case UNCOMMON: {
                    addition += 2 * level;
                    break;
                }
                case RARE: {
                    addition += 4 * level;
                    break;
                }
                case VERY_RARE: {
                    addition += 8 * level;
                }
            }
            cost += Math.max(1, addition / 2);
        }
        if (cost > 0) {
            ItemStack out = weapon.func_77946_l();
            out.func_82841_c(weapon.func_82838_A() * 2 + 1);
            EnchantmentHelper.func_82782_a((Map)wepEnch, (ItemStack)out);
            ev.setMaterialCost(1);
            ev.setCost(cost += weapon.func_82838_A());
            ev.setOutput(out);
            return true;
        }
        return false;
    }
}

