/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.IRegistryDelegate;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.objects.IEnchantingBlock;

public class EnchantmentStatRegistry {
    private static final Map<IRegistryDelegate<Block>, Stats> STATS = new HashMap<IRegistryDelegate<Block>, Stats>();

    public static void init() {
        EnchantmentStatRegistry.register(Blocks.field_196628_cT, 0.0f, -0.33333334f, 0.25f, 0.0f);
        EnchantmentStatRegistry.register(Blocks.field_150426_aN, 0.0f, -0.33333334f, 0.0f, 0.25f);
        EnchantmentStatRegistry.register(ApotheosisObjects.BLAZING_HELLSHELF, 30.0f, 2.0f, 0.3f, 0.0f);
        EnchantmentStatRegistry.register(ApotheosisObjects.GLOWING_HELLSHELF, 30.0f, 1.5f, 0.0f, 0.5f);
        EnchantmentStatRegistry.register(ApotheosisObjects.CRYSTAL_SEASHELF, 30.0f, 2.0f, 0.3f, 0.3f);
        EnchantmentStatRegistry.register(ApotheosisObjects.HEART_SEASHELF, 30.0f, 1.75f, 0.0f, 1.0f);
        EnchantmentStatRegistry.register(ApotheosisObjects.ENDSHELF, 40.0f, 3.0f, 0.35f, 0.35f);
        EnchantmentStatRegistry.register(ApotheosisObjects.PEARL_ENDSHELF, 40.0f, 3.0f, 0.5f, 0.75f);
        EnchantmentStatRegistry.register(ApotheosisObjects.DRACONIC_ENDSHELF, 50.0f, 4.0f, 0.0f, 0.0f);
        EnchantmentStatRegistry.register(ApotheosisObjects.BEESHELF, 0.0f, -15.0f, 10.0f, 0.0f);
        EnchantmentStatRegistry.register(ApotheosisObjects.MELONSHELF, 0.0f, -1.0f, -1.0f, 0.0f);
    }

    private static void register(Block block, float maxEterna, float eterna, float quanta, float arcana) {
        STATS.put((IRegistryDelegate<Block>)block.delegate, new Stats(maxEterna, eterna, quanta, arcana));
    }

    public static float getEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (STATS.containsKey(block.delegate)) {
            return EnchantmentStatRegistry.STATS.get((Object)block.delegate).eterna;
        }
        return state.getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public static float getMaxEterna(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (STATS.containsKey(block.delegate)) {
            return EnchantmentStatRegistry.STATS.get((Object)block.delegate).maxEterna;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getMaxEnchantingPower(state, (IWorldReader)world, pos);
        }
        return 15.0f;
    }

    public static float getQuanta(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (STATS.containsKey(block.delegate)) {
            return EnchantmentStatRegistry.STATS.get((Object)block.delegate).quanta;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static float getArcana(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (STATS.containsKey(block.delegate)) {
            return EnchantmentStatRegistry.STATS.get((Object)block.delegate).arcana;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getArcanaBonus(state, (IWorldReader)world, pos);
        }
        return 0.0f;
    }

    public static class Stats {
        final float maxEterna;
        final float eterna;
        final float quanta;
        final float arcana;

        public Stats(float maxEterna, float eterna, float quanta, float arcana) {
            this.maxEterna = maxEterna;
            this.eterna = eterna;
            this.quanta = quanta;
            this.arcana = arcana;
        }
    }
}

