/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item;

import com.teammetallurgy.aquaculture.Aquaculture;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;

public class LootBoxItem
extends Item {
    private final ResourceLocation lootTable;

    public LootBoxItem(ResourceLocation lootTable) {
        super(new Item.Properties().func_200916_a(Aquaculture.GROUP));
        this.lootTable = lootTable;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (world.field_72995_K || this.lootTable == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
        }
        if (world instanceof ServerWorld) {
            ServerWorld worldServer = (ServerWorld)world;
            LootContext.Builder builder = new LootContext.Builder(worldServer);
            List loot = worldServer.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable).func_216113_a(builder.func_216022_a(LootParameterSets.field_216260_a));
            if (!loot.isEmpty()) {
                ItemStack lootStack = (ItemStack)loot.get(0);
                player.func_146105_b(new TranslationTextComponent("aquaculture.loot.open", new Object[]{lootStack.func_200301_q()}).func_211708_a(TextFormatting.YELLOW), true);
                this.giveItem(player, lootStack);
                heldStack.func_190918_g(1);
                return new ActionResult(ActionResultType.SUCCESS, (Object)heldStack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    private void giveItem(PlayerEntity player, @Nonnull ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        } else if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
    }
}

