/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import muka2533.mods.asphaltmod.AsphaltModCore;
import muka2533.mods.asphaltmod.network.PacketNBT;
import muka2533.mods.asphaltmod.util.AsphaltModLogger;
import muka2533.mods.asphaltmod.util.LooseTrustManager;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class AsphaltModUtil {
    public static JFrame debugPanel;
    public static JList debugList;
    public static JTextField[] dubugTField;

    public static void sendPacketToClient(TileEntity tileEntity) {
        PacketNBT.sendToClient(tileEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public static World getClientWorld() {
        return AsphaltModCore.proxy.getWorld();
    }

    public static Item getPlayerHavingItem(EntityPlayer player) {
        if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] != null) {
            return player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77973_b();
        }
        return null;
    }

    public static ItemStack getPlayerHavingItemStack(EntityPlayer player) {
        if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] != null) {
            return player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        }
        return null;
    }

    public static boolean hasBlock(EntityPlayer player) {
        if (AsphaltModUtil.getPlayerHavingItem(player) != null) {
            Block block = Block.func_149634_a((Item)AsphaltModUtil.getPlayerHavingItem(player));
            return block != null && !block.equals(Blocks.field_150350_a);
        }
        return false;
    }

    public static Block getPlayerHavingBlock(EntityPlayer player) {
        if (AsphaltModUtil.hasBlock(player)) {
            return Block.func_149634_a((Item)player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77973_b());
        }
        return Blocks.field_150350_a;
    }

    public static int getPlayerDirection(EntityLivingBase entityLivingBase) {
        return MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static int getPlayerMiniDirection(EntityLivingBase entityLivingBase) {
        return MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
    }

    public static int getPlayerVerticalDirection(EntityLivingBase entityLivingBase) {
        return MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70125_A * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static void showDebugPanel(List<String> debugStrings) {
        if (debugPanel == null) {
            debugPanel = new JFrame("AsphaltMod");
            debugPanel.setSize(400, 300);
            debugPanel.setLocationRelativeTo(null);
            debugPanel.setAlwaysOnTop(true);
            try {
                debugPanel.setIconImage(new ImageIcon(new URL("https://mukanote.com/download/asphaltmod/img/crafting.png")).getImage());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                SwingUtilities.updateComponentTreeUI(debugPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            debugList = new JList<String>(debugStrings.toArray(new String[debugStrings.size()]));
            debugList.setForeground(new Color(61, 61, 61));
            debugList.setFont(debugList.getFont().deriveFont(18.0f));
            debugList.setFixedCellHeight(25);
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().setView(debugList);
            scroll.setPreferredSize(new Dimension(200, 80));
            JLabel label = new JLabel("\u30c7\u30d0\u30c3\u30b0\u30d1\u30cd\u30eb");
            label.setForeground(new Color(61, 61, 61));
            label.setFont(label.getFont().deriveFont(18.0f));
            JPanel panelMain = new JPanel();
            panelMain.setBackground(Color.WHITE);
            panelMain.setLayout(new BorderLayout(10, 10));
            panelMain.add(Box.createVerticalStrut(10), "North");
            panelMain.add(Box.createHorizontalStrut(10), "West");
            panelMain.add(Box.createHorizontalStrut(10), "East");
            JPanel panel = new JPanel();
            panel.setBackground(Color.WHITE);
            panel.setLayout(new BorderLayout(10, 10));
            panel.add((Component)label, "First");
            panel.add((Component)scroll, "Center");
            panelMain.add((Component)panel, "Center");
            debugPanel.getContentPane().add((Component)panelMain, "Center");
            debugPanel.setVisible(true);
        } else {
            debugList.setListData(debugStrings.toArray(new String[debugStrings.size()]));
        }
    }

    public static String getIPString(int index) {
        if (dubugTField.length == 0 || dubugTField[index] == null) {
            return "";
        }
        return dubugTField[index].getText();
    }

    public static int getIPInt(int index) {
        try {
            return Integer.parseInt(AsphaltModUtil.getIPString(index));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static float getIPFloat(int index) {
        try {
            return Float.parseFloat(AsphaltModUtil.getIPString(index));
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static void showInputPanel(int length) {
        JTextField[] dubugTField = new JTextField[length];
        for (int i = 0; i < length; ++i) {
            JTextField tfield = new JTextField(5);
            tfield.setPreferredSize(new Dimension(60, 20));
            tfield.setFont(new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 1, 16));
            dubugTField[i] = tfield;
        }
        AsphaltModUtil.showInputPanel(dubugTField);
    }

    public static void showInputPanel(JTextField[] dubugTField) {
        if (debugPanel == null) {
            AsphaltModUtil.dubugTField = dubugTField;
            debugPanel = new JFrame("AsphaltMod");
            debugPanel.setSize(400, 300);
            debugPanel.setLocationRelativeTo(null);
            debugPanel.setAlwaysOnTop(true);
            try {
                debugPanel.setIconImage(new ImageIcon(new URL("https://mukanote.com/download/asphaltmod/img/crafting.png")).getImage());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                SwingUtilities.updateComponentTreeUI(debugPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JPanel panelSub = new JPanel();
            panelSub.setBackground(Color.WHITE);
            for (int i = 0; i < AsphaltModUtil.dubugTField.length; ++i) {
                panelSub.add(AsphaltModUtil.dubugTField[i]);
            }
            JLabel label = new JLabel("\u30c7\u30d0\u30c3\u30b0\u30d1\u30cd\u30eb");
            label.setForeground(new Color(61, 61, 61));
            label.setFont(label.getFont().deriveFont(18.0f));
            JPanel panelMain = new JPanel();
            panelMain.setBackground(Color.WHITE);
            panelMain.setLayout(new BorderLayout(10, 10));
            panelMain.add(Box.createVerticalStrut(10), "North");
            panelMain.add(Box.createHorizontalStrut(10), "West");
            panelMain.add(Box.createHorizontalStrut(10), "East");
            JPanel panel = new JPanel();
            panel.setBackground(Color.WHITE);
            panel.setLayout(new BorderLayout(10, 10));
            panel.add((Component)label, "First");
            panel.add((Component)panelSub, "Center");
            panelMain.add((Component)panel, "Center");
            debugPanel.getContentPane().add((Component)panelMain, "Center");
            debugPanel.setVisible(true);
        }
    }

    public static void countPlay() {
        try {
            String str;
            URL url = new URL("https://vps.mukanote.com/counter/index.php");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new X509TrustManager[]{new LooseTrustManager()}, new SecureRandom());
            conn.setSSLSocketFactory(sslContext.getSocketFactory());
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            String parameterString = new String("type=count&name=asphaltmod");
            PrintWriter printWriter = new PrintWriter(conn.getOutputStream());
            printWriter.print(parameterString);
            printWriter.close();
            BufferedReader bufferReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "JISAutoDetect"));
            String httpSource = new String();
            while (null != (str = bufferReader.readLine())) {
                httpSource = httpSource + str;
            }
            bufferReader.close();
            conn.disconnect();
            if (httpSource.indexOf("SUCCESS") != -1) {
                AsphaltModLogger.info("Playcount is complete.");
            } else if (httpSource.indexOf("ERROR") != -1) {
                AsphaltModLogger.error("Playcount failed.");
            } else {
                AsphaltModLogger.warn("Playcount is not working");
            }
        }
        catch (MalformedURLException e) {
            AsphaltModLogger.error("Playcount failed." + e.getMessage());
        }
        catch (IOException e) {
            AsphaltModLogger.error("Playcount failed " + e.getMessage());
        }
        catch (KeyManagementException e) {
            AsphaltModLogger.error("Playcount failed " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            AsphaltModLogger.error("Playcount failed " + e.getMessage());
        }
    }

    public static int[] toRGB(String hexColorRGB) {
        char[] rgb = hexColorRGB.toCharArray();
        int[] rgbInt = new int[]{Character.digit(rgb[0], 16) * 16 + Character.digit(rgb[1], 16), Character.digit(rgb[2], 16) * 16 + Character.digit(rgb[3], 16), Character.digit(rgb[4], 16) * 16 + Character.digit(rgb[5], 16)};
        return rgbInt;
    }

    public static void renderAxis(Tessellator tessellator, double x, double y, double z, double angle) {
        GL11.glLineWidth((float)10.0f);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotated((double)angle, (double)x, (double)y, (double)z);
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.0);
        GL11.glEnd();
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)0.0, (double)-0.5, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.5, (double)0.0);
        GL11.glEnd();
        GL11.glColor3d((double)0.0, (double)0.0, (double)1.0);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.5);
        GL11.glEnd();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
    }

    public static boolean isJapanese() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a().equals("ja_JP");
    }

    public static String getItemBlockName(Block block, int meta) {
        Item item = Item.func_150898_a((Block)block);
        return StatCollector.func_74838_a((String)(item.func_77667_c(new ItemStack(block, 1, meta)) + ".name"));
    }
}

