/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.util;

import java.util.ArrayList;
import java.util.List;
import muka2533.mods.asphaltmod.util.SignText;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Sign {
    public String id;
    public int direction;
    public double position;
    public double height;
    public double width;
    private List<SignText> signTexts = new ArrayList<SignText>();

    public Sign(String id, int direction, double position) {
        this(id, direction, position, 1.0, 1.0);
    }

    public Sign(String id, int direction, double position, double height, double width) {
        this(id, direction, position, 1.0, 1.0, new ArrayList<SignText>());
    }

    public Sign(String id, int direction, double position, double height, double width, List<SignText> signTexts) {
        this.id = id;
        this.direction = direction;
        this.position = position;
        this.height = height;
        this.width = width;
        this.signTexts.addAll(signTexts);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("sign_id", this.id);
        nbt.func_74768_a("sign_direction", this.direction);
        nbt.func_74780_a("sign_position", this.position);
        nbt.func_74780_a("sign_height", this.height);
        nbt.func_74780_a("sign_width", this.width);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.signTexts.size(); ++i) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.signTexts.get(i).writeToNBT(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbt.func_74782_a("sign_signTexts", (NBTBase)tagList);
    }

    public static Sign loadSignFromNBT(NBTTagCompound nbt) {
        String id = nbt.func_74779_i("sign_id");
        int direction = nbt.func_74762_e("sign_direction");
        double position = nbt.func_74769_h("sign_position");
        double height = nbt.func_74769_h("sign_height");
        double width = nbt.func_74769_h("sign_width");
        if (height <= 0.0) {
            height = 1.0;
        }
        if (width <= 0.0) {
            width = 1.0;
        }
        ArrayList<SignText> signTexts = new ArrayList<SignText>();
        if (nbt.func_74781_a("sign_signTexts") != null) {
            NBTTagList tagList = (NBTTagList)nbt.func_74781_a("sign_signTexts");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                signTexts.add(SignText.loadSignFromNBT(tagList.func_150305_b(i)));
            }
        }
        return new Sign(id, direction, position, height, width, signTexts);
    }

    public void setSignText(SignText signText) {
        this.signTexts.add(signText);
    }

    public List<SignText> getSignTexts() {
        return this.signTexts;
    }
}

