/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.block;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import muka2533.mods.asphaltmod.block.BlockModelBase;
import muka2533.mods.asphaltmod.block.IVariationBlock;
import muka2533.mods.asphaltmod.init.AsphaltModBlock;
import muka2533.mods.asphaltmod.init.AsphaltModItem;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConcreteGutter
extends BlockModelBase
implements IVariationBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.9, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockConcreteGutter(String blockName) {
        super(Material.field_151576_e, blockName, 1.0f, 10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (this == AsphaltModBlock.CONCRETE_GUTTER || this == AsphaltModBlock.CONCRETE_GUTTER2) {
            if (blockState != iblockstate) {
                return true;
            }
            if (block == this) {
                return false;
            }
        }
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177229_b(TYPE) == EnumType.COVER || state.func_177229_b(TYPE) == EnumType.GRILL) {
            BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_AABB);
            BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM_AABB);
            if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
            } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST || state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            }
        } else if (state.func_177229_b(TYPE) == EnumType.EMPTY || state.func_177229_b(TYPE) == EnumType.NORMAL) {
            BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM_AABB);
            if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
            } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST || state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
                BlockConcreteGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (state.func_177229_b(TYPE) != EnumType.EMPTY) {
            worldIn.func_175688_a(EnumParticleTypes.WATER_BUBBLE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 1.0, 1.0, 1.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 1.0, 1.0, 1.0, new int[0]);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (worldIn.func_180495_p(pos).func_177229_b(TYPE) == EnumType.NORMAL) {
            worldIn.func_175688_a(EnumParticleTypes.WATER_BUBBLE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 1.0, 1.0, 1.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 1.0, 1.0, 1.0, new int[0]);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187806_ee, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            if (state.func_177229_b(TYPE) == EnumType.COVER) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.NORMAL)));
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(AsphaltModItem.CONCRETE_COVER)));
                }
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 1.0f, 0.5f, false);
                return true;
            }
            if (state.func_177229_b(TYPE) == EnumType.GRILL) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.NORMAL)));
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(AsphaltModItem.IRON_COVER)));
                }
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 1.0f, 0.5f, false);
                return true;
            }
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, EnumType.NORMAL.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.EMPTY.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.GRILL.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.COVER.getMetadata()));
    }

    @Override
    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        return iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (0 <= meta && meta <= 3) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)0));
        }
        if (4 <= meta && meta <= 7) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta - 4))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)1));
        }
        if (8 <= meta && meta <= 11) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta - 8))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)2));
        }
        if (12 <= meta && meta <= 16) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta - 12))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)3));
        }
        return this.func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() * 4 + ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public void onRegisterItemModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.NORMAL.func_176610_l(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.EMPTY.func_176610_l(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.GRILL.func_176610_l(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)3, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.COVER.func_176610_l(), "inventory"));
    }

    @Override
    public String getVariationName(int meta) {
        return EnumType.byMetadata(meta).unlocalizedName;
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0, "normal"),
        EMPTY(1, "empty"),
        GRILL(2, "grill"),
        COVER(3, "cover");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int meta, String name) {
            this(meta, name, name);
        }

        private EnumType(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockplanks$enumtype;
                EnumType.META_LOOKUP[blockplanks$enumtype.getMetadata()] = blockplanks$enumtype = enumTypeArray[i];
            }
        }
    }
}

