/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.block;

import java.util.List;
import javax.annotation.Nullable;
import muka2533.mods.asphaltmod.block.BlockModelBase;
import muka2533.mods.asphaltmod.block.IVariationBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockMetalPanel
extends BlockModelBase
implements IVariationBlock {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    protected static final AxisAlignedBB MS_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB WE_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB HIDE_MS_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected static final AxisAlignedBB HIDE_WE_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 1.0);

    public BlockMetalPanel(String blockName) {
        super(Material.field_76233_E, blockName, 2.0f, 30.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.ATTENTION)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            BlockMetalPanel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HIDE_MS_AABB);
        } else {
            BlockMetalPanel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HIDE_WE_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return MS_AABB;
        }
        return WE_AABB;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, EnumType.ATTENTION.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.SIDE_CHECK.getMetadata()));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata() + ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public void onRegisterItemModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.ATTENTION.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.ATTENTION.func_176610_l() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.SIDE_CHECK.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.SIDE_CHECK.func_176610_l() + ".obj", "inventory"));
    }

    @Override
    public String getVariationName(int meta) {
        return EnumType.byMetadata(meta).unlocalizedName;
    }

    public static enum EnumType implements IStringSerializable
    {
        ATTENTION(0, "attention"),
        SIDE_CHECK(1, "side_check");

        private static final EnumType[] META_LOOKUP;
        private final int index;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int index, String name) {
            this(index, name, name);
        }

        private EnumType(int index, String name, String unlocalizedName) {
            this.index = index;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static EnumType byIndex(int index) {
            return META_LOOKUP[index];
        }

        public static EnumType byMetadata(int meta) {
            return META_LOOKUP[meta / 4];
        }

        public int getIndex() {
            return this.index;
        }

        public int getMetadata() {
            return this.index * 4;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockplanks$enumtype;
                EnumType.META_LOOKUP[blockplanks$enumtype.getIndex()] = blockplanks$enumtype = enumTypeArray[i];
            }
        }
    }
}

