/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.block.renderer;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import muka2533.mods.asphaltmod.block.tileentity.TileEntityDigitalSignage;
import muka2533.mods.asphaltmod.util.AsphaltModLogger;
import muka2533.mods.asphaltmod.util.LooseTrustManager;
import muka2533.mods.asphaltmod.util.SignageScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class RenderDigitalSignage<T extends TileEntityDigitalSignage>
extends TileEntitySpecialRenderer<T> {
    public List<BufferedImage> screenBf = new ArrayList<BufferedImage>();
    public List<ResourceLocation> screen = new ArrayList<ResourceLocation>();
    public List<URI> screenLink = new ArrayList<URI>();
    public long startTime = 0L;
    public long time = 0L;
    private boolean renderScreen = false;
    private double screenX;
    private double screenSY;
    private double screenMY;
    private double screenSZ;
    private double screenMZ;

    public RenderDigitalSignage() {
    }

    public RenderDigitalSignage(double x, double y1, double y2, double z1, double z2) {
        this.screenX = x;
        this.screenSY = y1;
        this.screenMY = y2;
        this.screenSZ = z1;
        this.screenMZ = z2;
        this.renderScreen = true;
    }

    public int getIndex() {
        return (int)((System.currentTimeMillis() - this.startTime) / 10000L);
    }

    public void loadScreen(URL url) throws IOException, URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        HttpsURLConnection urlConn = null;
        InputStream in = null;
        BufferedReader reader = null;
        urlConn = (HttpsURLConnection)url.openConnection();
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new X509TrustManager[]{new LooseTrustManager()}, new SecureRandom());
        urlConn.setSSLSocketFactory(sslContext.getSocketFactory());
        urlConn.setRequestMethod("GET");
        urlConn.setConnectTimeout(2000);
        urlConn.setReadTimeout(2000);
        urlConn.connect();
        int status = urlConn.getResponseCode();
        if (status == 200) {
            String line;
            in = urlConn.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            if (output.toString() != "") {
                String strJson = output.toString();
                Gson gson = new Gson();
                Type listType = new TypeToken<List<SignageScreen>>(){}.getType();
                List screenList = (List)gson.fromJson(strJson, listType);
                for (int i = 0; i < screenList.size(); ++i) {
                    try {
                        URL urlScreen = new URL(((SignageScreen)screenList.get(i)).getURL());
                        this.screenBf.add(ImageIO.read(urlScreen.openStream()));
                        this.screenLink.add(new URI(((SignageScreen)screenList.get(i)).getLink()));
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                AsphaltModLogger.info("Loaded screens of the digital signage (" + url + ") : " + screenList.size());
            } else {
                AsphaltModLogger.warn("Missing to load screens of the digital signage: Json is empty.");
            }
        } else {
            AsphaltModLogger.warn("Missing to load screens of the digital signage: Http connection error " + status);
        }
    }

    public void render(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (this.screenBf.size() != 0) {
            for (int i = 0; i < this.screenBf.size(); ++i) {
                if (this.screenBf.get(i) == null) continue;
                this.screen.add(Minecraft.func_71410_x().func_110434_K().func_110578_a("screen", new DynamicTexture(this.screenBf.get(i))));
            }
            this.screenBf.clear();
        }
        if (this.screen.size() != 0) {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            if ((System.currentTimeMillis() - this.startTime) / 100L >= (long)(this.screen.size() * 100)) {
                this.startTime = System.currentTimeMillis();
            }
            this.time = (int)((System.currentTimeMillis() - this.startTime) / 100L);
        }
        if (this.renderScreen) {
            this.renderSignageScreen(te, x, y, z, this.screenX, this.screenSY, this.screenMY, this.screenSZ, this.screenMZ);
        } else {
            this.renderSignageScreen(te, x, y, z);
        }
        this.renderSignageBody(te, x, y, z);
    }

    public void renderSignageScreen(T te, double x, double y, double z, double x1, double y1, double y2, double z1, double z2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)(90.0f - 90.0f * (float)((TileEntityDigitalSignage)((Object)te)).direction), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        if (this.screen.size() != 0) {
            this.func_147499_a(this.screen.get(this.getIndex()));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181703_c);
            buffer.func_181662_b(x1, y1, z1).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x1, y2, z1).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x1, y2, z2).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            buffer.func_181662_b(x1, y1, z2).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        } else {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(x1, y1, z1).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(x1, y2, z1).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(x1, y2, z2).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(x1, y1, z2).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
    }

    public void renderSignageScreen(T te, double x, double y, double z) {
    }

    public abstract void renderSignageBody(T var1, double var2, double var4, double var6);
}

