/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.handler;

import java.io.IOException;
import muka2533.mods.asphaltmod.block.IRegisterItemModel;
import muka2533.mods.asphaltmod.handler.LinePackHandler;
import muka2533.mods.asphaltmod.handler.SignPackHandler;
import muka2533.mods.asphaltmod.init.AsphaltModBlock;
import muka2533.mods.asphaltmod.init.AsphaltModItem;
import muka2533.mods.asphaltmod.init.AsphaltModRecipe;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        AsphaltModItem.init();
        event.getRegistry().registerAll((IForgeRegistryEntry[])AsphaltModItem.ITEMS.toArray(new Item[0]));
        event.getRegistry().registerAll((IForgeRegistryEntry[])AsphaltModItem.ITEMBLOCKS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        AsphaltModBlock.init();
        event.getRegistry().registerAll((IForgeRegistryEntry[])AsphaltModBlock.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        AsphaltModRecipe.init();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("asphaltmod");
        for (Block block : AsphaltModBlock.BLOCKS) {
            if (!(block instanceof IRegisterItemModel)) continue;
            ((IRegisterItemModel)block).onRegisterItemModels(Item.func_150898_a((Block)block));
        }
        for (Item item : AsphaltModItem.ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/parking_gate"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/parking_gate_bar"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/digital_signage_tate"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/digital_signage_yoko"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/digital_signage_wall"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/road_sign_circle"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/road_sign_square"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/road_sign_triangle"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/metal_pole_black"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/metal_pole_brown"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/metal_pole_gray"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/metal_pole_white"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/metal_pole_orange"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/tetrapod"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/tetrapod_moss"));
        event.getMap().func_174942_a(new ResourceLocation("asphaltmod:blocks/color_cone"));
        try {
            SignPackHandler.INSTANCE.load();
            LinePackHandler.INSTANCE.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelBakeEvent(ModelBakeEvent event) {
        RegistryHandler.registerBlockModel(event, "parking_gate");
        RegistryHandler.registerBlockModel(event, "parking_gate_bar");
        RegistryHandler.registerBlockModel(event, "digital_signage_tate");
        RegistryHandler.registerBlockModel(event, "digital_signage_yoko");
        RegistryHandler.registerBlockModel(event, "digital_signage_wall");
        RegistryHandler.registerBlockModel(event, "road_sign_circle");
        RegistryHandler.registerBlockModel(event, "road_sign_square");
        RegistryHandler.registerBlockModel(event, "road_sign_triangle");
        RegistryHandler.registerBlockModel(event, "metal_pole_black");
        RegistryHandler.registerBlockModel(event, "metal_pole_brown");
        RegistryHandler.registerBlockModel(event, "metal_pole_gray");
        RegistryHandler.registerBlockModel(event, "metal_pole_white");
        RegistryHandler.registerBlockModel(event, "metal_pole_orange");
        RegistryHandler.registerBlockModel(event, "tetrapod");
        RegistryHandler.registerBlockModel(event, "tetrapod_moss");
        RegistryHandler.registerBlockModel(event, "color_cone");
    }

    private static void registerBlockModel(ModelBakeEvent event, String id) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("asphaltmod:block/" + id + ".obj"));
            IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("asphaltmod:block/" + id, "normal"), (Object)bakedModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

