/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.handler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import muka2533.mods.asphaltmod.util.AsphaltModLogger;
import muka2533.mods.asphaltmod.util.AsphaltModUtil;
import muka2533.mods.asphaltmod.util.SignInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SignPackHandler {
    public static final SignPackHandler INSTANCE = new SignPackHandler();
    private final Map<String, SignInfo> signInfoMap = new HashMap<String, SignInfo>();

    public void reset() {
        this.signInfoMap.clear();
    }

    public void load() throws IOException {
        File modsDir = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "mods");
        File modDir = new File(modsDir, "asphaltmod");
        File modRSDir = new File(modDir, "roadsign");
        File[] addons = modRSDir.listFiles();
        boolean isJapanese = Minecraft.func_71410_x().func_135016_M().func_135041_c() == Minecraft.func_71410_x().func_135016_M().func_191960_a("ja_jp");
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < addons.length; ++i) {
            if (!addons[i].isFile()) continue;
            if (addons[i].getName().endsWith(".zip") || addons[i].getName().endsWith(".ZIP")) {
                String[] charsets;
                HashMap map = new HashMap();
                for (String charset : charsets = new String[]{"UTF-8", "MS932"}) {
                    try {
                        ZipFile addonZip = new ZipFile(addons[i], Charset.forName(charset));
                        Enumeration<? extends ZipEntry> enu = addonZip.entries();
                        while (enu.hasMoreElements()) {
                            ZipEntry zipentry = enu.nextElement();
                            if (zipentry.isDirectory() || !zipentry.getName().endsWith(".png") && !zipentry.getName().endsWith(".jpg") && !zipentry.getName().endsWith(".bmp") && !zipentry.getName().endsWith(".gif")) continue;
                            String name = zipentry.getName().substring(zipentry.getName().lastIndexOf("/") + 1, zipentry.getName().lastIndexOf("."));
                            InputStream inputStream = addonZip.getInputStream(zipentry);
                            messages.addAll(this.loadSignPacks(name, inputStream));
                        }
                        addonZip.close();
                        break;
                    }
                    catch (Exception e) {
                        AsphaltModLogger.info("Sign pack zip has wrong charset.");
                        map.clear();
                    }
                }
                this.signInfoMap.putAll(map);
                continue;
            }
            if (!addons[i].getName().endsWith(".png") && !addons[i].getName().endsWith(".jpg") && !addons[i].getName().endsWith(".bmp") && !addons[i].getName().endsWith(".gif")) continue;
            String name = addons[i].getName().substring(addons[i].getName().lastIndexOf("/") + 1, addons[i].getName().lastIndexOf("."));
            FileInputStream inputStream = new FileInputStream(addons[i]);
            messages.addAll(this.loadSignPacks(name, inputStream));
        }
        if (messages.size() != 0) {
            this.showListMessage(messages.toArray(new String[messages.size()]), modRSDir);
        } else if (Minecraft.func_71410_x().field_71439_g != null) {
            if (isJapanese) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(this.getSignInfoList().size() + "\u500b\u306e\u6a19\u8b58\u306e\u8aad\u307f\u8fbc\u307f\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002"));
            } else {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Loading of " + this.getSignInfoList().size() + " sign was completed."));
            }
        }
    }

    public void checkDir() {
        File modsDir = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "mods");
        File modDir = new File(modsDir, "asphaltmod");
        File modRSDir = new File(modDir, "roadsign");
        if (!modDir.exists()) {
            modDir.mkdir();
        }
        if (!modRSDir.exists()) {
            modRSDir.mkdir();
        }
    }

    private void showListMessage(String[] strs, final File file) {
        final JFrame frame = new JFrame("AsphaltMod");
        frame.setSize(700, 500);
        frame.setLocationRelativeTo(null);
        frame.setAlwaysOnTop(true);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean isJapanese = Minecraft.func_71410_x().func_135016_M().func_135041_c() == Minecraft.func_71410_x().func_135016_M().func_191960_a("ja_jp");
        JList<String> list = new JList<String>(strs);
        list.setForeground(new Color(61, 61, 61));
        list.setFont(list.getFont().deriveFont(18.0f));
        list.setFixedCellHeight(25);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().setView(list);
        scroll.setPreferredSize(new Dimension(200, 80));
        JLabel label = new JLabel("\u6a19\u8b58\u30d1\u30c3\u30af\u306e\u30a8\u30e9\u30fc\uff08\u30ef\u30fc\u30eb\u30c9\u5185\u306b\u3066F10\u3067\u30ea\u30ed\u30fc\u30c9\uff09");
        if (!isJapanese) {
            label.setText("Errors in sign pack (Press F10 in the world to reload)");
        }
        label.setForeground(new Color(61, 61, 61));
        label.setFont(label.getFont().deriveFont(18.0f));
        JButton button = new JButton("\u6a19\u8b58\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f");
        if (!isJapanese) {
            button.setText("Open sign folder");
        }
        button.setForeground(new Color(61, 61, 61));
        button.setBackground(Color.WHITE);
        button.setFont(button.getFont().deriveFont(18.0f));
        button.setMargin(new Insets(15, 30, 15, 30));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JButton button2 = new JButton("\u30d8\u30eb\u30d7\u30da\u30fc\u30b8\u3092\u958b\u304f");
        if (!isJapanese) {
            button2.setText("Open help page");
        }
        button2.setForeground(new Color(61, 61, 61));
        button2.setBackground(Color.WHITE);
        button2.setFont(button.getFont().deriveFont(18.0f));
        button2.setMargin(new Insets(15, 30, 15, 30));
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        URI uri = new URI("https://mukanote.com/download/asphaltmod/signpack.html");
                        desktop.browse(uri);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JButton button3 = new JButton("\u9589\u3058\u308b");
        if (!isJapanese) {
            button3.setText("Close");
        }
        button3.setForeground(new Color(61, 61, 61));
        button3.setBackground(Color.WHITE);
        button3.setFont(button.getFont().deriveFont(18.0f));
        button3.setMargin(new Insets(15, 30, 15, 30));
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
            }
        });
        JPanel panelMain = new JPanel();
        panelMain.setBackground(Color.WHITE);
        panelMain.setLayout(new BorderLayout(10, 10));
        panelMain.add(Box.createVerticalStrut(10), "North");
        panelMain.add(Box.createHorizontalStrut(10), "West");
        panelMain.add(Box.createHorizontalStrut(10), "East");
        JPanel panelSub = new JPanel();
        panelSub.setBackground(Color.WHITE);
        panelSub.setLayout(new FlowLayout(0, 20, 20));
        panelSub.add(button);
        panelSub.add(button2);
        panelSub.add(button3);
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.setLayout(new BorderLayout(10, 10));
        panel.add((Component)label, "First");
        panel.add((Component)scroll, "Center");
        panelMain.add((Component)panel, "Center");
        frame.getContentPane().add((Component)panelMain, "Center");
        frame.getContentPane().add((Component)panelSub, "Last");
        frame.setVisible(true);
    }

    private boolean isShape(String str) {
        if (str.equalsIgnoreCase("circle")) {
            return true;
        }
        if (str.equalsIgnoreCase("triangle")) {
            return true;
        }
        if (str.equalsIgnoreCase("square")) {
            return true;
        }
        return str.equalsIgnoreCase("none");
    }

    private List<String> loadSignPacks(String name, InputStream inputStream) throws IOException {
        ArrayList<String> messages = new ArrayList<String>();
        String[] infos = name.split("&");
        if (infos.length == 3) {
            String signShape = infos[0];
            String signId = infos[1];
            String signName = infos[2];
            if (this.isShape(signShape)) {
                if (Pattern.matches("^[0-9a-zA-Z]+$", signId)) {
                    ResourceLocation resourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("rs_" + signId, new DynamicTexture(ImageIO.read(inputStream)));
                    inputStream.close();
                    SignInfo signInfo = new SignInfo(signName, signShape, signId);
                    signInfo.setTexture(resourceLocation);
                    this.signInfoMap.put(signId, signInfo);
                } else if (AsphaltModUtil.isJapanese()) {
                    messages.add("\u6a19\u8b58\u30c7\u30fc\u30bf [ " + name + ".png ] \u306fID\u306e\u6307\u5b9a [ " + signId + " ] \u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002\u534a\u89d2\u82f1\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                } else {
                    messages.add("In sign data [ " + name + ".png ], the ID specification [ " + signId + " ] is incorrect. Please enter alphanumeric characters.");
                }
            } else if (AsphaltModUtil.isJapanese()) {
                messages.add("\u6a19\u8b58\u30c7\u30fc\u30bf [ " + name + ".png ] \u306f\u30e2\u30c7\u30eb\u306e\u6307\u5b9a [ " + signShape + " ] \u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002circle,triangle,square,none \u306e\u3044\u305a\u308c\u304b\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                messages.add("In sign data [ " + name + ".png ], the model specification [ " + signShape + " ] is incorrect. Please enter one of circle, triangle, square, none.");
            }
        } else if (AsphaltModUtil.isJapanese()) {
            messages.add("\u6a19\u8b58\u30c7\u30fc\u30bf [ " + name + ".png ] \u306f\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u5f62\u5f0f\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002\u30e2\u30c7\u30eb\u540d&\u8b58\u5225\u7528ID&\u8868\u793a\u540d.png \u306e\u5f62\u5f0f\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        } else {
            messages.add("In sign data [ " + name + ".png ], wrong file name format. Please use the format of '[model name]&[identification ID]&[display name].png'.");
        }
        return messages;
    }

    public List<SignInfo> getSignInfoList() {
        ArrayList<SignInfo> list = new ArrayList<SignInfo>(this.signInfoMap.values());
        return list;
    }

    public Map<String, SignInfo> getSignInfoMap() {
        Map<String, SignInfo> map = this.signInfoMap;
        return map;
    }
}

