/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.signal;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class SignalGroup {
    private List<BlockPos> signals = new ArrayList<BlockPos>();
    private String name;

    public SignalGroup(List<BlockPos> p_signals, String p_name) {
        this.signals = p_signals;
        this.name = p_name;
    }

    public void setSignal(BlockPos signal) {
        this.signals.add(signal);
    }

    public void setName(String str) {
        this.name = str;
    }

    public List<BlockPos> getSignalAll() {
        return this.signals;
    }

    public BlockPos getSignal(int index) {
        return this.signals.get(index);
    }

    public void removeSignal(int index) {
        try {
            this.signals.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("SignalGroup_Name", this.name);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.signals.size(); ++i) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74772_a("BlockPos", this.signals.get(i).func_177986_g());
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbt.func_74782_a("SignalGroup_Signals", (NBTBase)tagList);
    }

    public static SignalGroup loadSignalGroupFromNBT(NBTTagCompound nbt) {
        String name = nbt.func_74779_i("SignalGroup_Name");
        ArrayList<BlockPos> signals = new ArrayList<BlockPos>();
        NBTTagList tagList = (NBTTagList)nbt.func_74781_a("SignalGroup_Signals");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            signals.add(BlockPos.func_177969_a((long)tagList.func_150305_b(i).func_74763_f("BlockPos")));
        }
        return new SignalGroup(signals, name);
    }

    public void writeToBuffer(ByteBuf buffer) throws UnsupportedEncodingException {
        byte[] byteName = this.name.getBytes("UTF-8");
        buffer.writeInt(byteName.length);
        buffer.writeBytes(byteName);
        buffer.writeInt(this.signals.size());
        for (int i = 0; i < this.signals.size(); ++i) {
            buffer.writeLong(this.signals.get(i).func_177986_g());
        }
    }

    public static SignalGroup loadSignalGroupBuffer(ByteBuf buffer) throws UnsupportedEncodingException {
        int length = buffer.readInt();
        byte[] byteName = new byte[length];
        buffer.readBytes(byteName);
        String name = new String(byteName, "UTF-8");
        ArrayList<BlockPos> signals = new ArrayList<BlockPos>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            signals.add(BlockPos.func_177969_a((long)buffer.readLong()));
        }
        return new SignalGroup(signals, name);
    }
}

