/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.util.math.Vec3d;

public class RenderUtil {
    public static Vec3d partLocation(RendererModel ... parts) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (RendererModel part : parts) {
            x += part.field_78795_f + RenderUtil.xOffset(part);
            y += part.field_78796_g + RenderUtil.yOffset(part);
            z += part.field_78808_h + RenderUtil.zOffset(part);
        }
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public static void partTranslateRotate(RendererModel ... parts) {
        for (RendererModel part : parts) {
            RenderUtil.offsetTranslate(part);
            RenderUtil.pointTranslate(part);
            GlStateManager.rotatef((float)((float)Math.toDegrees(part.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)((float)Math.toDegrees(part.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)((float)Math.toDegrees(part.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public static void partScaleTranslate(RendererModel part, float scale) {
        RenderUtil.offsetTranslate(part);
        RenderUtil.pointTranslate(part);
        RenderUtil.scale(scale);
        RenderUtil.negativeOffsetTranslate(part);
        RenderUtil.negativePointTranslate(part);
    }

    public static void partScaleTranslate(RendererModel part, double scale) {
        RenderUtil.partScaleTranslate(part, (float)scale);
    }

    public static void partScaleTranslate(RendererModel part, float scaleX, float scaleY, float scaleZ) {
        RenderUtil.offsetTranslate(part);
        RenderUtil.pointTranslate(part);
        GlStateManager.scalef((float)scaleX, (float)scaleY, (float)scaleZ);
        RenderUtil.negativeOffsetTranslate(part);
        RenderUtil.negativePointTranslate(part);
    }

    public static void partScaleTranslate(RendererModel part, double scaleX, double scaleY, double scaleZ) {
        RenderUtil.partScaleTranslate(part, (float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public static void offsetTranslate(RendererModel part) {
        GlStateManager.translatef((float)RenderUtil.xOffset(part), (float)RenderUtil.yOffset(part), (float)RenderUtil.zOffset(part));
    }

    public static void negativeOffsetTranslate(RendererModel part) {
        GlStateManager.translatef((float)(-RenderUtil.xOffset(part)), (float)(-RenderUtil.yOffset(part)), (float)(-RenderUtil.zOffset(part)));
    }

    public static void pointTranslate(RendererModel part) {
        GlStateManager.translatef((float)(part.field_78800_c / 16.0f), (float)(part.field_78797_d / 16.0f), (float)(part.field_78798_e / 16.0f));
    }

    public static void negativePointTranslate(RendererModel part) {
        GlStateManager.translatef((float)(-part.field_78800_c / 16.0f), (float)(-part.field_78797_d / 16.0f), (float)(-part.field_78798_e / 16.0f));
    }

    public static void scale(float scale) {
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
    }

    public static void scale(double scale) {
        RenderUtil.scale((float)scale);
    }

    public static float xOffset(RendererModel part) {
        return part.field_82906_o / 16.0f;
    }

    public static float yOffset(RendererModel part) {
        return part.field_82908_p / 16.0f;
    }

    public static float zOffset(RendererModel part) {
        return part.field_82907_q / 16.0f;
    }
}

