/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariantTypes;
import its_meow.betteranimalsplus.common.entity.EntityBobbitWorm;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAP;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntitySharkBase;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.util.OceanBiomeHelper;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EntityShark
extends EntitySharkBase {
    private float lastAttack = 0.0f;
    private float lastGrab = 0.0f;
    private float lastTickHealth = 0.0f;
    public float lastBodyRotation = 0.0f;

    public EntityShark(World world) {
        super((EntityType<? extends EntitySharkBase>)ModEntities.SHARK.entityType, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 1.0, 40.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 1));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((MobEntity)this, LivingEntity.class, 5, false, false, e -> {
            if (e instanceof EntitySharkBase || e instanceof EntityBobbitWorm) {
                return false;
            }
            if (e instanceof PlayerEntity) {
                return this.shouldAttackForHealth(e.func_110143_aJ());
            }
            return true;
        }){

            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityShark.this.isPeaceful();
            }
        });
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            PlayerEntity player;
            if (source.func_76364_f() instanceof PlayerEntity && !this.isPeaceful() && !(player = (PlayerEntity)source.func_76364_f()).func_184812_l_() && !player.func_82150_aj()) {
                this.func_70624_b((LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.5);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public IVariantTypes<EntityWaterMobPathing> setType(IVariant variant) {
        super.setType(variant);
        this.updateAttributes(this.getVariantNameOrEmpty());
        return this;
    }

    @Override
    public IVariantTypes<EntityWaterMobPathing> setType(String variantKey) {
        super.setType(variantKey);
        this.updateAttributes(this.getVariantNameOrEmpty());
        return this;
    }

    private void updateAttributes(String name) {
        if ("hammerhead".equals(name)) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(45.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(9.0);
        } else if ("mako".equals(name)) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(3.0);
        } else if ("great_white".equals(name)) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.5);
        }
        this.func_70606_j(this.func_110138_aP());
    }

    public boolean shouldAttackForHealth(float health) {
        switch (this.getVariantNameOrEmpty()) {
            case "blue": {
                return health <= 8.0f;
            }
            case "bull": {
                return health <= 13.0f;
            }
            case "tiger": {
                return health <= 10.0f;
            }
            case "whitetip": {
                return health <= 16.0f;
            }
            case "greenland": {
                return health <= 8.0f;
            }
            case "hammerhead": {
                return health <= 8.0f;
            }
            case "goblin": {
                return health <= 8.0f;
            }
            case "mako": {
                return health <= 13.0f;
            }
            case "great_white": {
                return health <= 13.0f;
            }
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70089_S() && !this.isPeaceful()) {
            float grabDelay;
            boolean isBoat = this.func_70638_az() instanceof PlayerEntity && this.func_70638_az().func_184187_bx() != null && this.func_70638_az().func_184187_bx() instanceof BoatEntity;
            float f = grabDelay = isBoat ? 20.0f : 60.0f;
            if (this.func_184188_bt().contains(this.func_70638_az())) {
                float time = 30.0f;
                if (this.lastAttack + (time = (float)((double)time * (Math.random() + 1.0))) < (float)this.field_70173_aa) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            } else if (this.lastGrab + grabDelay < (float)this.field_70173_aa && this.func_70068_e((Entity)this.func_70638_az()) < 5.0) {
                if (isBoat) {
                    BoatEntity boat = (BoatEntity)this.func_70638_az().func_184187_bx();
                    boat.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 3.0f);
                } else if (!this.func_70638_az().func_190530_aW() && (double)this.func_70638_az().func_213311_cf() < 2.5 && (double)this.func_70638_az().func_213302_cg() < 2.5) {
                    if (this.func_70638_az() instanceof MobEntity) {
                        MobEntity el = (MobEntity)this.func_70638_az();
                        el.func_70624_b(null);
                        el.func_70604_c(null);
                        el.func_70661_as().func_75499_g();
                        el.func_94061_f(true);
                    }
                    this.func_70638_az().func_184205_a((Entity)this, false);
                } else if (!this.func_70638_az().func_190530_aW()) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                this.lastGrab = this.field_70173_aa;
            }
            if (this.lastTickHealth - 4.0f > this.func_110143_aJ()) {
                this.func_70638_az().func_110145_l((Entity)this);
                if (this.func_70638_az() instanceof MobEntity) {
                    MobEntity el = (MobEntity)this.func_70638_az();
                    el.func_94061_f(false);
                }
            }
        }
        this.lastTickHealth = this.func_110143_aJ();
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.SHARK;
    }

    @Override
    public EntityTypeContainerBAP<EntityShark> getContainer() {
        return ModEntities.SHARK;
    }

    @Override
    public String[] getTypesFor(Biome biome, Set<BiomeDictionary.Type> types) {
        ArrayList<String> list = new ArrayList<String>();
        OceanBiomeHelper.Wrapper b = new OceanBiomeHelper.Wrapper(biome);
        if (b.isColdOrFrozen()) {
            list.add("greenland");
        } else {
            list.add("bull");
            list.add("blue");
            list.add("whitetip");
            list.add("tiger");
        }
        if (!b.isFrozen()) {
            list.add("great_white");
        }
        if (b.isDeep()) {
            list.add("goblin");
            if (!b.isFrozen()) {
                list.add("mako");
            }
        }
        if (b.isWarm()) {
            list.add("mako");
        }
        return list.toArray(new String[0]);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        if (((EntityTypeContainerBAP)this.getContainer()).biomeVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
            if (!this.getImplementation().func_70631_g_()) {
                IVariant variant;
                int i;
                Biome biome = world.func_180494_b(this.getImplementation().func_180425_c());
                String[] validTypes = this.getTypesFor(biome, BiomeDictionary.getTypes((Biome)biome));
                String varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
                for (i = 0; i < 2; ++i) {
                    if (!"great_white".equals(varStr) && !"goblin".equals(varStr)) continue;
                    varStr = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
                }
                if (world instanceof World && ((World)world).func_72935_r() && validTypes.length > 1 && "goblin".equals(varStr)) {
                    for (i = 0; i < validTypes.length && "goblin".equals(varStr); ++i) {
                        varStr = validTypes[i];
                    }
                }
                if ((variant = this.getContainer().getVariantForName(varStr)) == null || !varStr.equals(variant.getName())) {
                    throw new RuntimeException("Received invalid variant string from selective type: " + varStr + " on entity " + ((EntityTypeContainerBAP)this.getContainer()).entityName);
                }
                if (livingdata instanceof IVariantTypes.TypeData) {
                    variant = ((IVariantTypes.TypeData)livingdata).typeData;
                } else {
                    livingdata = new IVariantTypes.TypeData(variant);
                }
                this.setType(variant);
            }
        } else {
            return super.func_213386_a(world, difficulty, reason, livingdata, compound);
        }
        return livingdata;
    }
}

