/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.tileentity;

import its_meow.betteranimalsplus.common.entity.miniboss.hirschgeist.EntityHirschgeist;
import its_meow.betteranimalsplus.init.ModBlocks;
import its_meow.betteranimalsplus.init.ModTileEntities;
import its_meow.betteranimalsplus.init.ModTriggers;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityHandOfFate
extends TileEntity {
    private boolean onFire;
    private final String keyOnFire = "OnFire";
    private boolean hasNetherWart;
    private final String keyNetherWart = "HasNetherWart";
    private boolean hasAntler;
    private final String keyAntler = "HasAntler";
    private boolean hasVenison;
    private final String keyVenison = "HasVenison";

    public TileEntityHandOfFate() {
        super(ModTileEntities.HAND_OF_FATE_TYPE);
    }

    public TileEntityHandOfFate(World worldIn) {
        super(ModTileEntities.HAND_OF_FATE_TYPE);
        this.field_145850_b = worldIn;
    }

    public void setOnFire(boolean b) {
        this.onFire = b;
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), 100);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
        }
        this.func_70296_d();
    }

    public boolean isOnFire() {
        return this.onFire;
    }

    public boolean hasNetherWart() {
        return this.hasNetherWart;
    }

    public void setHasNetherWart(PlayerEntity player, boolean hasNetherWart) {
        this.hasNetherWart = hasNetherWart;
        this.func_70296_d();
        this.checkHasAllThree(player);
    }

    public boolean hasAntler() {
        return this.hasAntler;
    }

    public void setHasAntler(PlayerEntity player, boolean hasAntler) {
        this.hasAntler = hasAntler;
        this.func_70296_d();
        this.checkHasAllThree(player);
    }

    public boolean hasVenison() {
        return this.hasVenison;
    }

    public void setHasVenison(PlayerEntity player, boolean hasVenison) {
        this.hasVenison = hasVenison;
        this.func_70296_d();
        this.checkHasAllThree(player);
    }

    private void checkHasAllThree(PlayerEntity player) {
        if (this.hasVenison && this.hasAntler && this.hasNetherWart && this.isOnFire()) {
            this.setHasVenison(player, false);
            this.setHasAntler(player, false);
            this.setHasNetherWart(player, false);
            this.fireBurst();
            this.spawnHirschgeist();
            if (!this.field_145850_b.field_72995_K && player instanceof ServerPlayerEntity) {
                ModTriggers.HAND_OF_FATE_SUMMON.trigger((ServerPlayerEntity)player);
            }
        }
    }

    private void spawnHirschgeist() {
        if (!this.field_145850_b.field_72995_K) {
            EntityHirschgeist hg = new EntityHirschgeist(this.field_145850_b);
            hg.func_70012_b(this.field_174879_c.func_177958_n(), (float)this.field_174879_c.func_177956_o() + 1.0f, this.field_174879_c.func_177952_p(), 0.0f, 0.0f);
            hg.func_94061_f(false);
            this.field_145850_b.func_217376_c((Entity)hg);
        }
    }

    private void fireBurst() {
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)this.func_174877_v().func_177958_n() + (rand.nextFloat() + 0.5f) / 2.0f), (double)((float)this.func_174877_v().func_177956_o() + 1.5f), (double)((float)this.func_174877_v().func_177952_p() + (rand.nextFloat() + 0.5f) / 2.0f), 0.0, 0.5, 0.0);
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(this.keyOnFire)) {
            this.onFire = compound.func_74767_n(this.keyOnFire);
        }
        if (compound.func_74764_b(this.keyNetherWart)) {
            this.hasNetherWart = compound.func_74767_n(this.keyNetherWart);
        }
        if (compound.func_74764_b(this.keyAntler)) {
            this.hasAntler = compound.func_74767_n(this.keyAntler);
        }
        if (compound.func_74764_b(this.keyVenison)) {
            this.hasVenison = compound.func_74767_n(this.keyVenison);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a(this.keyOnFire, this.onFire);
        compound.func_74757_a(this.keyAntler, this.hasAntler);
        compound.func_74757_a(this.keyNetherWart, this.hasNetherWart);
        compound.func_74757_a(this.keyVenison, this.hasVenison);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), 100);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotation() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == ModBlocks.HAND_OF_FATE) {
            Direction facing = ((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)).func_176734_d();
            if (facing == Direction.NORTH) {
                return 0.0f;
            }
            if (facing == Direction.EAST) {
                return 90.0f;
            }
            if (facing == Direction.SOUTH) {
                return 180.0f;
            }
            if (facing == Direction.WEST) {
                return 270.0f;
            }
        }
        return 0.0f;
    }
}

