/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.config;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityRegistrarHandler;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.MobEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="betteranimalsplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterAnimalsPlusConfig {
    private static EntityRegistrarHandler.ServerEntityConfiguration SERVER_CONFIG = null;
    public static ForgeConfigSpec SERVER_CONFIG_SPEC = null;
    private static EntityRegistrarHandler.ClientEntityConfiguration CLIENT_CONFIG = null;
    public static ForgeConfigSpec CLIENT_CONFIG_SPEC = null;

    public static ForgeConfigSpec getClientSpec() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModEntities.H::clientConfig);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT_CONFIG = (EntityRegistrarHandler.ClientEntityConfiguration)specPair.getLeft();
        return CLIENT_CONFIG_SPEC;
    }

    public static ForgeConfigSpec getServerSpec() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModEntities.H::serverConfig);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER_CONFIG = (EntityRegistrarHandler.ServerEntityConfiguration)specPair.getLeft();
        return SERVER_CONFIG_SPEC;
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        BetterAnimalsPlusMod.logger.debug("Loading {} {}", (Object)"betteranimalsplus", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG_SPEC) {
            SERVER_CONFIG.onWorldLoad();
        } else if (configEvent.getConfig().getSpec() == CLIENT_CONFIG_SPEC) {
            CLIENT_CONFIG.onLoad();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.ConfigReloading configEvent) {
        BetterAnimalsPlusMod.logger.debug("Reloading {} {}", (Object)"betteranimalsplus", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG_SPEC) {
            SERVER_CONFIG.onLoad();
        } else if (configEvent.getConfig().getSpec() == CLIENT_CONFIG_SPEC) {
            CLIENT_CONFIG.onLoad();
        }
    }

    public static Map<String, String[]> getTameItemsMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (EntityTypeContainer<? extends MobEntity> cont : ModEntities.getEntities().values()) {
            if (!(cont instanceof EntityTypeContainerBAPTameable)) continue;
            EntityTypeContainerBAPTameable c = (EntityTypeContainerBAPTameable)cont;
            map.put(c.entityName, c.getTameItems());
        }
        return map;
    }
}

