/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.network;

import com.google.common.base.Charsets;
import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.client.dumb.SafeSyncThing;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class StupidDevPacket {
    public final boolean on;
    public final boolean nametag;
    public final String variant;
    public UUID appliesTo;

    public StupidDevPacket(boolean on, boolean nametag, String variant) {
        this.on = on;
        this.nametag = nametag;
        this.variant = variant;
    }

    public StupidDevPacket(boolean on, boolean nametag, String variant, UUID appliesTo) {
        this.on = on;
        this.nametag = nametag;
        this.variant = variant;
        this.appliesTo = appliesTo;
    }

    public StupidDevPacket(SafeSyncThing.DumbOptions opt) {
        this.on = opt.on;
        this.nametag = opt.nametag;
        this.variant = opt.variant;
    }

    public StupidDevPacket(SafeSyncThing.DumbOptions opt, UUID appliesTo) {
        this.on = opt.on;
        this.nametag = opt.nametag;
        this.variant = opt.variant;
        this.appliesTo = appliesTo;
    }

    public static void encode(StupidDevPacket pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.on);
        buf.writeBoolean(pkt.nametag);
        buf.writeInt(pkt.variant.length());
        buf.writeCharSequence((CharSequence)pkt.variant, Charsets.UTF_8);
        if (pkt.appliesTo != null) {
            buf.func_179252_a(pkt.appliesTo);
        }
    }

    public static StupidDevPacket decode(PacketBuffer buf) {
        boolean on = buf.readBoolean();
        boolean nametag = buf.readBoolean();
        int len = buf.readInt();
        String variant = String.valueOf(buf.readCharSequence(len, Charsets.UTF_8));
        if (buf.isReadable()) {
            UUID from = buf.func_179253_g();
            return new StupidDevPacket(on, nametag, variant, from);
        }
        return new StupidDevPacket(on, nametag, variant);
    }

    public static class Handler {
        public static void handle(StupidDevPacket msg, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                ctx.get().enqueueWork(() -> SafeSyncThing.put(msg.appliesTo, msg));
            }
            if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                ctx.get().enqueueWork(() -> {
                    if (BetterAnimalsPlusMod.isDev((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                        SafeSyncThing.put(((NetworkEvent.Context)ctx.get()).getSender().func_146103_bH().getId(), msg);
                        msg.appliesTo = ((NetworkEvent.Context)ctx.get()).getSender().func_146103_bH().getId();
                        for (ServerPlayerEntity player : ((NetworkEvent.Context)ctx.get()).getSender().func_184102_h().func_184103_al().func_181057_v()) {
                            if (player == ((NetworkEvent.Context)ctx.get()).getSender()) continue;
                            BetterAnimalsPlusMod.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
                        }
                    }
                });
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

