/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.util;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariantTypes;
import its_meow.betteranimalsplus.common.block.BlockGenericSkull;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAP;
import its_meow.betteranimalsplus.common.item.ItemBlockHeadType;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHead;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

public class HeadType {
    protected static final Set<HeadType> HEADS = new HashSet<HeadType>();
    protected static final Map<String, HeadType> HEADS_MAP = new HashMap<String, HeadType>();
    protected static final Map<Block, HeadType> HEADS_BLOCK_MAP = new HashMap<Block, HeadType>();
    private final String name;
    private final PlacementType placement;
    private final Map<IVariant, Pair<BlockGenericSkull, ItemBlockHeadType>> heads = new HashMap<IVariant, Pair<BlockGenericSkull, ItemBlockHeadType>>();
    private final Set<ItemBlockHeadType> items = new HashSet<ItemBlockHeadType>();
    private final Set<BlockGenericSkull> blocks = new HashSet<BlockGenericSkull>();
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Supplier<EntityModel<? extends Entity>>> modelSupplier;
    private final EntityTypeContainerBAP<? extends LivingEntity> container;
    private float yOffset = 0.0f;
    private IVariant singletonVariant;
    private final Map<Block, IVariant> reverseVariantMap = new HashMap<Block, IVariant>();

    public static Set<HeadType> values() {
        return HEADS;
    }

    public static HeadType valueOf(String name) {
        return HEADS_MAP.get(name);
    }

    public static HeadType valueOf(Block block) {
        return HEADS_BLOCK_MAP.get(block);
    }

    public HeadType(String name, PlacementType placement, float yOffset, HeadIDMapping mapping, @Nullable Function<IVariant, String> variantMapper, @Nullable IVariant singletonVariant, @Nullable String singletonID, EntityTypeContainerBAP<? extends LivingEntity> container) {
        this.name = name;
        this.placement = placement;
        this.yOffset = yOffset;
        this.container = container;
        if (!container.hasVariants() && mapping != HeadIDMapping.SINGLETON) {
            throw new RuntimeException("Tried to create non-singleton head type with a variantless entity!");
        }
        switch (mapping) {
            case NAMES: {
                for (IVariant variant : container.getVariants()) {
                    if (!variant.hasHead()) continue;
                    BlockGenericSkull block = new BlockGenericSkull(this, variant.getName());
                    ItemBlockHeadType item = new ItemBlockHeadType((Block)block, this, variant.getName(), variant);
                    this.heads.put(variant, (Pair<BlockGenericSkull, ItemBlockHeadType>)Pair.of((Object)((Object)block), (Object)((Object)item)));
                    this.blocks.add(block);
                    this.items.add(item);
                    this.reverseVariantMap.put((Block)block, variant);
                    HEADS_BLOCK_MAP.put((Block)block, this);
                }
                break;
            }
            case NUMBERS: {
                for (IVariant variant : container.getVariants()) {
                    if (!variant.hasHead()) continue;
                    int index = container.getVariants().indexOf((Object)variant) + 1;
                    BlockGenericSkull block = new BlockGenericSkull(this, String.valueOf(index));
                    ItemBlockHeadType item = new ItemBlockHeadType((Block)block, this, String.valueOf(index), variant);
                    this.heads.put(variant, (Pair<BlockGenericSkull, ItemBlockHeadType>)Pair.of((Object)((Object)block), (Object)((Object)item)));
                    this.blocks.add(block);
                    this.items.add(item);
                    this.reverseVariantMap.put((Block)block, variant);
                    HEADS_BLOCK_MAP.put((Block)block, this);
                }
                break;
            }
            case CUSTOM: {
                for (IVariant variant : container.getVariants()) {
                    if (!variant.hasHead()) continue;
                    String id = variantMapper.apply(variant);
                    BlockGenericSkull block = new BlockGenericSkull(this, id);
                    ItemBlockHeadType item = new ItemBlockHeadType((Block)block, this, id, variant);
                    this.heads.put(variant, (Pair<BlockGenericSkull, ItemBlockHeadType>)Pair.of((Object)((Object)block), (Object)((Object)item)));
                    this.blocks.add(block);
                    this.items.add(item);
                    this.reverseVariantMap.put((Block)block, variant);
                    HEADS_BLOCK_MAP.put((Block)block, this);
                }
                break;
            }
            case SINGLETON: {
                BlockGenericSkull block = new BlockGenericSkull(this, singletonID);
                ItemBlockHeadType item = new ItemBlockHeadType((Block)block, this, singletonID, singletonVariant);
                this.heads.put(singletonVariant, (Pair<BlockGenericSkull, ItemBlockHeadType>)Pair.of((Object)((Object)block), (Object)((Object)item)));
                this.blocks.add(block);
                this.items.add(item);
                this.reverseVariantMap.put((Block)block, singletonVariant);
                HEADS_BLOCK_MAP.put((Block)block, this);
                this.singletonVariant = singletonVariant;
            }
        }
        HEADS.add(this);
        HEADS_MAP.put(name, this);
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public IVariant getVariant(Block block) {
        return this.reverseVariantMap.get(block);
    }

    public Pair<BlockGenericSkull, ItemBlockHeadType> getPair(IVariant variant) {
        return this.heads.get(variant);
    }

    public BlockGenericSkull getBlock(IVariant variant) {
        if (this.getPair(variant) == null) {
            return null;
        }
        return (BlockGenericSkull)((Object)this.getPair(variant).getLeft());
    }

    public ItemBlockHeadType getItem(IVariant variant) {
        if (this.getPair(variant) == null) {
            return null;
        }
        return (ItemBlockHeadType)((Object)this.getPair(variant).getRight());
    }

    public BlockGenericSkull getBlock() {
        if (this.getPair(this.singletonVariant) == null) {
            return null;
        }
        return (BlockGenericSkull)((Object)this.getPair(this.singletonVariant).getLeft());
    }

    public ItemBlockHeadType getItem() {
        if (this.getPair(this.singletonVariant) == null) {
            return null;
        }
        return (ItemBlockHeadType)((Object)this.getPair(this.singletonVariant).getRight());
    }

    public Set<ItemBlockHeadType> getItemSet() {
        return this.items;
    }

    public Set<BlockGenericSkull> getBlockSet() {
        return this.blocks;
    }

    public TileEntityHead createTE() {
        return new TileEntityHead(this);
    }

    public String getName() {
        return this.name;
    }

    public PlacementType getPlacementType() {
        return this.placement;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Supplier<Supplier<EntityModel<? extends Entity>>> getModelSupplier() {
        return this.modelSupplier;
    }

    public static BlockGenericSkull[] getAllBlocks() {
        ArrayList<BlockGenericSkull> blocks = new ArrayList<BlockGenericSkull>();
        for (HeadType type : HeadType.values()) {
            blocks.addAll(type.getBlockSet());
        }
        BlockGenericSkull[] list = new BlockGenericSkull[blocks.size()];
        list = blocks.toArray(list);
        return list;
    }

    public EntityTypeContainerBAP<? extends LivingEntity> getContainer() {
        return this.container;
    }

    public IVariant getSingletonVariant() {
        return this.singletonVariant;
    }

    public void drop(MobEntity entity, int chance) {
        this.drop(entity, chance, this.getHeadID(entity));
    }

    public void drop(MobEntity entity, int chance, Optional<IVariant> variant) {
        if (variant.isPresent() && !entity.field_70170_p.field_72995_K && !entity.func_70631_g_() && entity.func_70681_au().nextInt(chance) == 0) {
            ItemStack stack = new ItemStack((IItemProvider)this.getItem(variant.get()));
            entity.func_70099_a(stack, 0.5f);
        }
    }

    private Optional<IVariant> getHeadID(MobEntity entity) {
        if (entity instanceof IVariantTypes && this.container.hasVariants()) {
            IVariantTypes ent = (IVariantTypes)entity;
            return ent.getVariant();
        }
        return Optional.of(this.singletonVariant);
    }

    public static class Builder<T extends MobEntity, C extends EntityTypeContainerBAP<T>, B extends EntityTypeContainerBAP.AbstractEntityBuilderBAP<T, C, B>> {
        private final String name;
        private PlacementType placement;
        private float yOffset;
        @OnlyIn(value=Dist.CLIENT)
        private Supplier<Supplier<EntityModel<?>>> modelSupplier;
        private HeadIDMapping idMapping;
        private Function<IVariant, String> customMapper;
        private IVariant singletonVariant;
        private String singletonID;
        private final B initial;

        public Builder(B initial, String name) {
            this.initial = initial;
            this.name = name;
            this.placement = PlacementType.WALL_ONLY;
            this.yOffset = 0.0f;
            this.idMapping = null;
        }

        public Builder<T, C, B> mapToNames() {
            this.idMapping = HeadIDMapping.NAMES;
            return this;
        }

        public Builder<T, C, B> mapToNumbers() {
            this.idMapping = HeadIDMapping.NUMBERS;
            return this;
        }

        public Builder<T, C, B> mapToCustom(Function<IVariant, String> customMapper) {
            this.idMapping = HeadIDMapping.CUSTOM;
            this.customMapper = customMapper;
            return this;
        }

        public Builder<T, C, B> singleton(String id, String texture) {
            this.idMapping = HeadIDMapping.SINGLETON;
            this.singletonID = id;
            this.singletonVariant = new EntityVariant("betteranimalsplus", id, texture);
            return this;
        }

        public Builder<T, C, B> allowFloor() {
            this.placement = PlacementType.FLOOR_AND_WALL;
            return this;
        }

        public Builder<T, C, B> setModel(Supplier<Supplier<EntityModel<? extends Entity>>> modelSupplier) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                this.modelSupplier = modelSupplier;
            }
            return this;
        }

        public Builder<T, C, B> offset(float yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public B done() {
            ((EntityTypeContainerBAP.AbstractEntityBuilderBAP)this.initial).setHeadBuild(this::build);
            return this.initial;
        }

        public HeadType build(C container) {
            if (this.idMapping == null) {
                throw new RuntimeException("No ID mapping set for head builder " + this.name);
            }
            HeadType type = new HeadType(this.name, this.placement, this.yOffset, this.idMapping, this.customMapper, this.singletonVariant, this.singletonID, (EntityTypeContainerBAP<? extends LivingEntity>)container);
            if (FMLEnvironment.dist == Dist.CLIENT) {
                type.modelSupplier = this.modelSupplier;
            }
            return type;
        }
    }

    public static enum HeadIDMapping {
        NAMES,
        NUMBERS,
        CUSTOM,
        SINGLETON;

    }

    public static enum PlacementType {
        FLOOR_AND_WALL,
        WALL_ONLY;

    }
}

