/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.item.ModSpawnEggItem;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class EntityRegistrarHandler {
    public final String modid;
    public final LinkedHashMap<String, EntityTypeContainer<? extends MobEntity>> ENTITIES = new LinkedHashMap();
    private static final Method ADDSPAWN = ObfuscationReflectionHelper.findMethod(Biome.class, (String)"func_201866_a", (Class[])new Class[]{EntityClassification.class, Biome.SpawnListEntry.class});
    private static final Field SERIALIZABLE = ObfuscationReflectionHelper.findField(EntityType.class, (String)"field_200733_aL");

    public EntityRegistrarHandler(String modid) {
        this.modid = modid;
    }

    public void gatherData(DataGenerator gen, ExistingFileHelper helper) {
        gen.func_200390_a((IDataProvider)new ModSpawnEggItem.DataProvider(this, gen, helper));
    }

    public <T extends MobEntity> EntityTypeContainer<T> getEntityTypeContainer(String name) {
        return this.ENTITIES.get(name);
    }

    public <T extends MobEntity> EntityType<T> getEntityType(String name) {
        return this.ENTITIES.get((Object)name).entityType;
    }

    public <T extends MobEntity, C extends EntityTypeContainer<T>> C add(IEntityBuilder<T, C, ?> builder) {
        C c = builder.build();
        ((EntityTypeContainer)c).entityType = this.createEntityType((EntityTypeContainer<T>)c);
        ((EntityTypeContainer)c).onCreateEntityType();
        this.ENTITIES.put(((EntityTypeContainer)c).entityName, (EntityTypeContainer<? extends MobEntity>)c);
        return c;
    }

    public <T extends MobEntity> EntityType<T> createEntityType(EntityTypeContainer<T> container) {
        return this.createEntityType(container.entityClass, container.factory, container.entityName, container.spawnType, 64, 1, true, container.width, container.height);
    }

    public <T extends Entity> EntityType<T> createEntityType(Class<T> EntityClass, Function<World, T> func, String entityNameIn, EntityClassification classification, int trackingRange, int updateInterval, boolean velUpdates, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a((etype, world) -> (Entity)func.apply(world), (EntityClassification)classification).setTrackingRange(trackingRange).setUpdateInterval(updateInterval).setShouldReceiveVelocityUpdates(velUpdates).func_220321_a(width, height).setCustomClientFactory((e, world) -> (Entity)func.apply((World)world)).func_200706_c().func_206830_a(this.modid + ":" + entityNameIn.toLowerCase());
        type.setRegistryName(this.modid + ":" + entityNameIn.toLowerCase());
        try {
            EntityRegistrarHandler.setFinalField(SERIALIZABLE, type, true);
        }
        catch (Exception e2) {
            LogManager.getLogger().warn("Unable to set serializable for {}. This could result in possible saving issues with entities!", (Object)entityNameIn);
        }
        return type;
    }

    private static void setFinalField(Field field, Object object, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(object, newValue);
    }

    public ServerEntityConfiguration serverConfig(ForgeConfigSpec.Builder builder) {
        return new ServerEntityConfiguration(builder);
    }

    public ClientEntityConfiguration clientConfig(ForgeConfigSpec.Builder builder) {
        return new ClientEntityConfiguration(builder);
    }

    public class ClientEntityConfiguration {
        ClientEntityConfiguration(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"This is the CLIENTSIDE configuration for " + EntityRegistrarHandler.this.modid + ".", "To configure SERVER values (spawning, behavior, etc), go to:", "saves/(world)/serverconfig/" + EntityRegistrarHandler.this.modid + "-server.toml", "or, on a dedicated server:", "(world)/serverconfig/" + EntityRegistrarHandler.this.modid + "-server.toml"});
            builder.push("entities");
            EntityRegistrarHandler.this.ENTITIES.values().forEach(c -> c.clientCustomConfigurationInit(builder));
            builder.pop();
        }

        public void onLoad() {
            EntityRegistrarHandler.this.ENTITIES.values().forEach(EntityTypeContainer::clientConfigurationLoad);
        }
    }

    public class ServerEntityConfiguration {
        ServerEntityConfiguration(ForgeConfigSpec.Builder builder) {
            builder.push("entities");
            EntityRegistrarHandler.this.ENTITIES.values().forEach(c -> c.initConfiguration(builder));
            builder.pop();
        }

        public void onLoad() {
            for (EntityTypeContainer<? extends MobEntity> container : EntityRegistrarHandler.this.ENTITIES.values()) {
                EntityTypeContainer.EntityConfiguration section = container.getConfiguration();
                container.configurationLoad();
                ArrayList<Biome> biomesList = new ArrayList<Biome>();
                for (String biomeID : (List)section.biomesList.get()) {
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeID));
                    if (biome == null) {
                        LogManager.getLogger().error("[" + EntityRegistrarHandler.this.modid + "] Invalid biome configuration entered for entity \"" + container.entityName + "\" (biome was mistyped or a biome mod was removed?): " + biomeID);
                        continue;
                    }
                    biomesList.add(biome);
                }
                container.setBiomes(biomesList.toArray(new Biome[0]));
            }
        }

        public void onWorldLoad() {
            this.onLoad();
            if (!EntityRegistrarHandler.this.ENTITIES.values().isEmpty()) {
                for (EntityTypeContainer<? extends MobEntity> entry : EntityRegistrarHandler.this.ENTITIES.values()) {
                    EntityType type = entry.entityType;
                    if (!entry.doSpawning) continue;
                    entry.registerPlacement();
                    for (Biome biome : entry.getBiomes()) {
                        try {
                            biome.func_201866_a(entry.spawnType, new Biome.SpawnListEntry(type, entry.spawnWeight, entry.spawnMinGroup, entry.spawnMaxGroup));
                        }
                        catch (IllegalAccessError e) {
                            try {
                                ADDSPAWN.invoke((Object)biome, entry.spawnType, new Biome.SpawnListEntry(type, entry.spawnWeight, entry.spawnMinGroup, entry.spawnMaxGroup));
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e2) {
                                e2.printStackTrace();
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }
}

