/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.item;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityRegistrarHandler;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelProvider;

public class ModSpawnEggItem
extends SpawnEggItem {
    private final EntityType<?> type;
    private final String modid;
    private final String name;

    public ModSpawnEggItem(EntityTypeContainer<?> container) {
        super(container.entityType, container.eggColorSolid, container.eggColorSpot, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        this.type = container.entityType;
        this.modid = container.getModId();
        this.name = container.entityName.toLowerCase();
        this.setRegistryName(container.getModId(), this.name + "_spawn_egg");
    }

    public String func_77667_c(ItemStack stack) {
        if (this.type != null) {
            return "entity." + this.modid + "." + this.type.getRegistryName().func_110623_a();
        }
        return "item." + this.modid + ".emptyegg";
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent("misc." + this.modid + ".eggorder", new Object[]{new TranslationTextComponent(this.func_77667_c(stack), new Object[0])});
    }

    public EntityType<?> func_208076_b(CompoundNBT tag) {
        return this.type;
    }

    public boolean func_208077_a(CompoundNBT tag, EntityType<?> type) {
        return type == this.type;
    }

    public static class DataProvider
    extends ItemModelProvider {
        private EntityRegistrarHandler handler;

        public DataProvider(EntityRegistrarHandler r, DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, r.modid, existingFileHelper);
            this.handler = r;
        }

        public String func_200397_b() {
            return this.modid + "_spawn_eggs";
        }

        protected void registerModels() {
            for (String name : this.handler.ENTITIES.keySet()) {
                this.withExistingParent(name + "_spawn_egg", new ResourceLocation("minecraft", "item/template_spawn_egg"));
            }
        }
    }
}

