/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus;

import com.google.common.collect.ImmutableList;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import its_meow.betteranimalsplus.client.ClientLifecycleHandler;
import its_meow.betteranimalsplus.client.dumb.SafeSyncThing;
import its_meow.betteranimalsplus.common.entity.EntityCoyote;
import its_meow.betteranimalsplus.common.entity.projectile.EntityGoldenGooseEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityGooseEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityModEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityPheasantEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityTurkeyEgg;
import its_meow.betteranimalsplus.config.BetterAnimalsPlusConfig;
import its_meow.betteranimalsplus.init.ModBlocks;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModTriggers;
import its_meow.betteranimalsplus.network.ClientConfigurationPacket;
import its_meow.betteranimalsplus.network.ClientRequestBAMPacket;
import its_meow.betteranimalsplus.network.HonkPacket;
import its_meow.betteranimalsplus.network.ServerNoBAMPacket;
import its_meow.betteranimalsplus.network.StupidDevPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="betteranimalsplus")
@Mod(value="betteranimalsplus")
public class BetterAnimalsPlusMod {
    public static final Logger logger = LogManager.getLogger();
    public static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("betteranimalsplus", "main_channel")).clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).networkProtocolVersion(() -> "2").simpleChannel();
    public static int packets = 0;
    public static final WeightedBlockStateProvider TRILLIUM_STATE_PROVIDER = new WeightedBlockStateProvider();
    public static final BlockClusterFeatureConfig TRILLIUM_FEATURE_CONFIG;
    private static final ImmutableList<UUID> DEVS;
    public static ItemGroup group;

    public BetterAnimalsPlusMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dataSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> new ClientLifecycleHandler().clientSetup((FMLClientSetupEvent)e));
        ModTriggers.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, BetterAnimalsPlusConfig.getClientSpec());
        logger.log(Level.INFO, "Injecting super coyotes...");
    }

    public static final boolean isDev(UUID uuid) {
        return DEVS.contains((Object)uuid);
    }

    public static final boolean isDev(PlayerEntity player) {
        return BetterAnimalsPlusMod.isDev(player.func_146103_bH().getId());
    }

    private void setup(FMLCommonSetupEvent event) {
        HANDLER.registerMessage(packets++, ClientConfigurationPacket.class, ClientConfigurationPacket::encode, ClientConfigurationPacket::decode, ClientConfigurationPacket.Handler::handle);
        HANDLER.registerMessage(packets++, ServerNoBAMPacket.class, (pkt, buf) -> {}, buf -> new ServerNoBAMPacket(), (pkt, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> BetterAnimalsPlusMod.lambda$null$4((Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        HANDLER.registerMessage(packets++, ClientRequestBAMPacket.class, (pkt, buf) -> {}, buf -> new ClientRequestBAMPacket(), (pkt, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
                if (!ModList.get().isLoaded("betteranimals")) {
                    HANDLER.sendToServer((Object)new ServerNoBAMPacket());
                }
            });
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        HANDLER.registerMessage(packets++, StupidDevPacket.class, StupidDevPacket::encode, StupidDevPacket::decode, StupidDevPacket.Handler::handle);
        HANDLER.registerMessage(packets++, HonkPacket.class, HonkPacket::encode, HonkPacket::decode, HonkPacket.Handler::handle);
        DeferredWorkQueue.runLater(() -> BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP).forEach(biome -> biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)TRILLIUM_FEATURE_CONFIG).func_227228_a_(Placement.field_215020_f.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 0, 3))))));
        BetterAnimalsPlusMod.registerEggDispenser(ModItems.PHEASANT_EGG, EntityPheasantEgg::new);
        BetterAnimalsPlusMod.registerEggDispenser(ModItems.TURKEY_EGG, EntityTurkeyEgg::new);
        BetterAnimalsPlusMod.registerEggDispenser(ModItems.GOOSE_EGG, EntityGooseEgg::new);
        BetterAnimalsPlusMod.registerEggDispenser(ModItems.GOLDEN_GOOSE_EGG, EntityGoldenGooseEgg::new);
        DefaultDispenseItemBehavior eggDispense = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, (PlayerEntity)null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (EntityTypeContainer<? extends MobEntity> container : ModEntities.getEntities().values()) {
            DispenserBlock.func_199774_a((IItemProvider)container.egg, (IDispenseItemBehavior)eggDispense);
        }
        logger.log(Level.INFO, "Overspawning lammergeiers...");
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, BetterAnimalsPlusConfig.getServerSpec());
        logger.log(Level.INFO, "Finished crazy bird creation!");
    }

    private void dataSetup(GatherDataEvent event) {
        ModEntities.H.gatherData(event.getGenerator(), event.getExistingFileHelper());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getPlayer() instanceof ServerPlayerEntity) {
            HANDLER.sendTo((Object)new ClientConfigurationPacket(EntityCoyote.HOSTILE_DAYTIME, BetterAnimalsPlusConfig.getTameItemsMap()), ((ServerPlayerEntity)e.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            HANDLER.sendTo((Object)new ClientRequestBAMPacket(), ((ServerPlayerEntity)e.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            for (UUID devId : DEVS) {
                HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getPlayer()), (Object)new StupidDevPacket(SafeSyncThing.get(devId), devId));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getPlayer() instanceof ServerPlayerEntity) {
            for (UUID devId : DEVS) {
                SafeSyncThing.put(devId, SafeSyncThing.DumbOptions.OFF);
                HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getPlayer()), (Object)new StupidDevPacket(SafeSyncThing.DumbOptions.OFF, devId));
            }
        }
    }

    private static <T extends EntityModEgg> void registerEggDispenser(Item item, final IEggEntityProvider<T> provider) {
        DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (IProjectile)Util.func_200696_a(provider.create(worldIn, position), p_218408_1_ -> p_218408_1_.func_213884_b(stackIn));
            }
        });
    }

    private static /* synthetic */ void lambda$null$4(Supplier ctx) {
        ModTriggers.NO_BAM.trigger(((NetworkEvent.Context)ctx.get()).getSender());
    }

    static {
        for (int i = 0; i < 4; ++i) {
            TRILLIUM_STATE_PROVIDER.func_227407_a_((BlockState)ModBlocks.TRILLIUM.func_176223_P().func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)Direction.func_176731_b((int)i)), 1);
        }
        TRILLIUM_FEATURE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)TRILLIUM_STATE_PROVIDER, (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        DEVS = ImmutableList.of((Object)UUID.fromString("81d9726a-56d4-4419-9a2a-be1d7f7f7ef1"), (Object)UUID.fromString("403f2fd4-f8a2-4608-a0b8-534da4184735"), (Object)UUID.fromString("4605663e-fb07-4843-98c5-73adbfb2625e"));
        group = new ItemGroup("Better Animals+"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.ANTLER);
            }

            public void func_78018_a(NonNullList<ItemStack> toDisplay) {
                super.func_78018_a(toDisplay);
                ModEntities.getEntities().values().forEach(cont -> toDisplay.add((Object)new ItemStack((IItemProvider)cont.egg)));
            }
        };
    }

    @FunctionalInterface
    private static interface IEggEntityProvider<T extends EntityModEgg> {
        public T create(World var1, IPosition var2);
    }
}

