/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IContainerEntity;
import its_meow.betteranimalsplus.common.entity.EntityDeer;
import its_meow.betteranimalsplus.common.entity.EntityPheasant;
import its_meow.betteranimalsplus.common.entity.ai.EntityAIEatBerries;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAP;
import its_meow.betteranimalsplus.common.entity.util.IDropHead;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBear
extends AnimalEntity
implements IContainerEntity<EntityBear>,
IDropHead {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;

    public EntityBear(World worldIn) {
        super(ModEntities.BROWN_BEAR.entityType, worldIn);
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
    }

    public EntityBear(EntityType<? extends EntityBear> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this){

            public boolean func_75250_a() {
                return EntityBear.this.func_70090_H() && EntityBear.this.func_212107_bY() > 0.6 || EntityBear.this.func_180799_ab();
            }
        });
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new EntityAIEatBerries((CreatureEntity)this, 1.0, 12, 2));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SalmonEntity.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityDeer.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PigEntity.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ChickenEntity.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RabbitEntity.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityPheasant.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, FoxEntity.class, 90, true, true, (Predicate)Predicates.alwaysTrue()));
    }

    public boolean func_70877_b(ItemStack stack) {
        return ItemTags.field_206964_G.func_199685_a_((Object)stack.func_77973_b()) || stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    public boolean isPeaceful() {
        return this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(1.0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.BEAR_BROWN;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimation0) {
                this.func_213323_x_();
            }
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStandingAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.clientSideStandAnimation0, (float)this.clientSideStandAnimation) / 6.0f;
    }

    protected float func_189749_co() {
        return 0.97f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.func_213305_a(poseIn).func_220312_a(1.0f, f1);
        }
        return super.func_213305_a(poseIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_220302_v;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    public boolean func_213397_c(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityBear getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainerBAP<?> getContainer() {
        return ModEntities.BROWN_BEAR;
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return new EntityBear(this.field_70170_p);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn instanceof GroupData) {
            this.func_70873_a(-24000);
        } else {
            spawnDataIn = new GroupData();
        }
        return spawnDataIn;
    }

    static class GroupData
    implements ILivingEntityData {
        private GroupData() {
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)EntityBear.this, 2.0);
        }

        public boolean func_75250_a() {
            return !EntityBear.this.func_70631_g_() && !EntityBear.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)EntityBear.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)enemy);
                EntityBear.this.setStanding(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityBear.this.setStanding(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityBear.this.setStanding(true);
                    EntityBear.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
                EntityBear.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityBear.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 8.0f + attackTarget.func_213311_cf();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)EntityBear.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityBear.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (!(!(mobIn instanceof EntityBear) || mobIn.func_70631_g_() || targetIn instanceof PlayerEntity && ((EntityBear)mobIn).isPeaceful())) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)EntityBear.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (EntityBear.this.isPeaceful() || EntityBear.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (EntityBear bear : EntityBear.this.field_70170_p.func_217357_a(EntityBear.class, EntityBear.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!bear.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }
}

