/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.IVariantTypes;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAP;
import its_meow.betteranimalsplus.common.entity.util.IDropHead;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import its_meow.betteranimalsplus.init.ModTriggers;
import java.util.Calendar;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityReindeer
extends AnimalEntity
implements IJumpingMount,
IVariantTypes<EntityReindeer>,
IDropHead {
    protected static final Predicate<LivingEntity> IS_REINDEER_BREEDING = entity -> entity instanceof EntityReindeer && ((EntityReindeer)entity).isBreeding();
    private static final EntityPredicate PARENT_TARGETING = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221011_b().func_221014_c().func_221012_a(IS_REINDEER_BREEDING);
    protected static final IAttribute JUMP_STRENGTH = new RangedAttribute((IAttribute)null, "reindeer.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    protected static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityReindeer.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int eatingCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean reindeerJumping;
    protected float jumpPower;
    private boolean allowStandSliding;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    protected boolean canGallop = true;
    protected int gallopTime;
    public boolean parentRudolph = false;
    public static boolean CREATE_SNOW = true;

    public EntityReindeer(World worldIn) {
        super(ModEntities.REINDEER.entityType, worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, EntityReindeer.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.registerTypeKey();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = !itemstack.func_190926_b();
        if (flag && itemstack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_()) {
            if (player.func_213453_ef()) {
                return false;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (flag) {
            if (this.handleEating(player, itemstack)) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_111282_a(player, (LivingEntity)this, hand)) {
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        this.mountTo(player);
        return true;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityReindeer)) {
            return false;
        }
        return this.canMate() && ((EntityReindeer)otherAnimal).canMate();
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        EntityReindeer reindeer = new EntityReindeer(this.field_70170_p);
        this.setOffspringAttributes(ageable, reindeer);
        if (ageable instanceof EntityReindeer) {
            EntityReindeer other = (EntityReindeer)ageable;
            if (other.getVariantNameOrEmpty().endsWith("christmas")) {
                reindeer.setType((IVariant)other.getVariant().get());
            } else {
                reindeer.setType((IVariant)this.getVariant().get());
            }
            if (other.func_145818_k_() && other.func_200201_e().getString().equalsIgnoreCase("rudolph") || this.func_145818_k_() && this.func_200201_e().getString().equalsIgnoreCase("rudolph")) {
                reindeer.parentRudolph = true;
            }
        } else {
            reindeer.setType((IVariant)this.getVariant().get());
        }
        return reindeer;
    }

    protected boolean getReindeerWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & p_110233_1_) != 0;
    }

    protected void setReindeerWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        if (p_110208_2_) {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.field_70180_af.func_187227_b(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public float getReindeerSize() {
        return 0.5f;
    }

    public boolean isReindeerJumping() {
        return this.reindeerJumping;
    }

    public void setReindeerJumping(boolean jumping) {
        this.reindeerJumping = jumping;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return super.func_184652_a(player);
    }

    protected void func_142017_o(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isEatingHaystack() {
        return this.getReindeerWatchableBoolean(16);
    }

    public boolean isRearing() {
        return this.getReindeerWatchableBoolean(32);
    }

    public boolean isBreeding() {
        return this.getReindeerWatchableBoolean(8);
    }

    public void setBreeding(boolean breeding) {
        this.setReindeerWatchableBoolean(8, breeding);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void eatingReindeer() {
        this.openReindeerMouth();
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187711_cp, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, (float)i);
                }
            }
            BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 0.2 - (double)this.field_70126_B, this.func_226281_cx_());
            BlockState iblockstate = this.field_70170_p.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.getSoundType(block.func_176223_P(), (IWorldReader)this.field_70170_p, pos, (Entity)this);
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
        return true;
    }

    public double getReindeerJumpStrength() {
        return this.func_110148_a(JUMP_STRENGTH).func_111126_e();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.openReindeerMouth();
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.openReindeerMouth();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.makeReindeerRear();
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        this.openReindeerMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.makeReindeerRear();
        }
        return null;
    }

    @Nullable
    protected SoundEvent getAngrySound() {
        this.openReindeerMouth();
        this.makeReindeerRear();
        return null;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = blockIn.getSoundType(blockIn.func_176223_P(), (IWorldReader)this.field_70170_p, pos, (Entity)this);
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE) {
                soundtype = Blocks.field_150433_aE.getSoundType(Blocks.field_150433_aE.func_176223_P(), (IWorldReader)this.field_70170_p, pos, (Entity)this);
            }
            if (this.func_184207_aI() && this.canGallop) {
                ++this.gallopTime;
                if (this.gallopTime > 5 && this.gallopTime % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopTime <= 5) {
                    this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    protected void playGallopSound(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187714_cq, p_190680_1_.func_185843_a() * 0.15f, p_190680_1_.func_185847_b());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(JUMP_STRENGTH);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.225f);
    }

    public int func_70641_bl() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    protected boolean handleEating(PlayerEntity player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O || item == Items.field_151172_bF) {
            f = 2.0f;
            i = 20;
            if (!this.func_70631_g_() && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
        } else if (item == Items.field_151150_bK) {
            f = 4.0f;
            i = 60;
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao) {
            f = 10.0f;
            i = 240;
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (flag) {
            this.eatingReindeer();
        }
        return flag;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTables.reindeer;
    }

    protected void mountTo(PlayerEntity player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (player instanceof ServerPlayerEntity) {
            ModTriggers.RIDE_REINDEER.trigger((ServerPlayerEntity)player);
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() || this.isEatingHaystack() || this.isRearing();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d() && CREATE_SNOW && this.field_70146_Z.nextInt(10) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(4) - 2.0, this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(4), this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(4) - 2.0, 0.0, (double)-0.2f, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEatingHaystack() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)this.func_226278_cu_()) - 1, MathHelper.func_76128_c((double)this.func_226281_cx_()))).func_177230_c() == Blocks.field_150349_c) {
                    this.setEatingHaystack(true);
                }
                if (this.isEatingHaystack() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEatingHaystack(false);
                }
            }
            this.followMother();
        }
    }

    protected void followMother() {
        LivingEntity livingentity;
        if (this.isBreeding() && this.func_70631_g_() && !this.isEatingHaystack() && (livingentity = this.field_70170_p.func_217360_a(AbstractHorseEntity.class, PARENT_TARGETING, (LivingEntity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_174813_aQ().func_186662_g(16.0))) != null && this.func_70068_e((Entity)livingentity) > 4.0) {
            this.field_70699_by.func_75494_a((Entity)livingentity, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setReindeerWatchableBoolean(64, false);
        }
        if (this.func_184186_bw() && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.prevHeadLean = this.headLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getReindeerWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openReindeerMouth() {
        if (!this.field_70170_p.field_72995_K) {
            this.openMouthCounter = 1;
            this.setReindeerWatchableBoolean(64, true);
        }
    }

    public void setEatingHaystack(boolean p_110227_1_) {
        this.setReindeerWatchableBoolean(16, p_110227_1_);
    }

    public void setRearing(boolean rearing) {
        if (rearing) {
            this.setEatingHaystack(false);
        }
        this.setReindeerWatchableBoolean(32, rearing);
    }

    private void makeReindeerRear() {
        if (this.func_184186_bw()) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void func_213352_e(Vec3d vec) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            double d0;
            LivingEntity entitylivingbase = (LivingEntity)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            vec = vec.func_72441_c((double)(entitylivingbase.field_70702_br * 0.5f) - vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            vec = vec.func_72441_c(vec.field_72450_a, vec.field_72448_b, (double)entitylivingbase.field_191988_bg - vec.field_72449_c);
            if (vec.field_72449_c <= 0.0) {
                vec = vec.func_216372_d(1.0, 1.0, 0.25);
                this.gallopTime = 0;
            }
            if (this.field_70122_E && this.jumpPower == 0.0f && this.isRearing() && !this.allowStandSliding) {
                vec = vec.func_216372_d(0.0, 1.0, 0.0);
            }
            if (this.jumpPower > 0.0f && !this.isReindeerJumping() && this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, this.getReindeerJumpStrength() * (double)this.jumpPower - this.func_213322_ci().field_72448_b, 0.0));
                if (this.func_70644_a(Effects.field_76430_j)) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f), 0.0));
                }
                this.setReindeerJumping(true);
                this.field_70160_al = true;
                if (vec.field_72449_c > 0.0) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f * this.jumpPower), 0.0, (double)(0.4f * f1 * this.jumpPower)));
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_213352_e(vec);
            } else if (entitylivingbase instanceof PlayerEntity) {
                this.func_213293_j(0.0, 0.0, 0.0);
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setReindeerJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.func_226277_ct_() - this.field_70169_q;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_213352_e(vec);
        }
    }

    public void func_200203_b(ITextComponent comp) {
        if (comp.getString().toLowerCase().equals("rudolph") && this.getVariant() != null && !this.getVariantNameOrEmpty().endsWith("_christmas")) {
            this.setType(this.getVariantNameOrEmpty() + "_christmas");
        }
        super.func_200203_b(comp);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("EatingHaystack", this.isEatingHaystack());
        compound.func_74757_a("Bred", this.isBreeding());
        this.writeType(compound);
        compound.func_74757_a("IsParentRudolph", this.parentRudolph);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setEatingHaystack(compound.func_74767_n("EatingHaystack"));
        this.setBreeding(compound.func_74767_n("Bred"));
        this.parentRudolph = compound.func_74767_n("IsParentRudolph");
        IAttributeInstance iattributeinstance = this.func_110140_aT().func_111152_a("Speed");
        if (iattributeinstance != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(iattributeinstance.func_111125_b() * 0.25);
        }
        this.readType(compound);
        Calendar calendar = Calendar.getInstance();
        if (!(!this.getVariantNameOrEmpty().endsWith("_christmas") || calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28 || this.func_200201_e().getString().toLowerCase().equals("rudolph") || this.parentRudolph)) {
            this.setType(this.getVariantNameOrEmpty().substring(0, 1));
        }
    }

    protected boolean canMate() {
        return !this.func_184207_aI() && this.func_184187_bx() == null && !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    protected void setOffspringAttributes(AgeableEntity p_190681_1_, EntityReindeer p_190681_2_) {
        double d0 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.getModifiedMaxHealth();
        p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d0 / 3.0);
        double d1 = this.func_110148_a(JUMP_STRENGTH).func_111125_b() + p_190681_1_.func_110148_a(JUMP_STRENGTH).func_111125_b() + this.getModifiedJumpStrength();
        p_190681_2_.func_110148_a(JUMP_STRENGTH).func_111128_a(d1 / 3.0);
        double d2 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + p_190681_1_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.getModifiedMovementSpeed();
        p_190681_2_.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2 / 3.0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrassEatingAmount(float p_110258_1_) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * p_110258_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRearingAmount(float p_110223_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_110223_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMouthOpennessAngle(float p_110201_1_) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * p_110201_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        } else {
            this.allowStandSliding = true;
            this.makeReindeerRear();
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public boolean func_184776_b() {
        return true;
    }

    public void func_184775_b(int p_184775_1_) {
        this.allowStandSliding = true;
        this.makeReindeerRear();
    }

    public void func_184777_r_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnReindeerParticles(boolean p_110216_1_) {
        BasicParticleType enumparticletypes = p_110216_1_ ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)enumparticletypes, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.spawnReindeerParticles(true);
        } else if (id == 6) {
            this.spawnReindeerParticles(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof MobEntity) {
            MobEntity entityliving = (MobEntity)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
        if (this.prevRearingAmount > 0.0f) {
            float f3 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.prevRearingAmount;
            float f2 = 0.15f * this.prevRearingAmount;
            passenger.func_70107_b(this.func_226277_ct_() + (double)(f1 * f3), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W() + (double)f2, this.func_226281_cx_() - (double)(f1 * f));
            if (passenger instanceof LivingEntity) {
                ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    protected float getModifiedMaxHealth() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    protected double getModifiedJumpStrength() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    protected double getModifiedMovementSpeed() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean wearsArmor() {
        return false;
    }

    public boolean isArmor(ItemStack stack) {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        return this.initAgeableData(world, reason, super.func_213386_a(world, difficulty, reason, livingdata, compound));
    }

    @Override
    public IVariant getRandomType() {
        Calendar calendar = Calendar.getInstance();
        boolean isChristmasSeason = calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28;
        boolean redNosed = this.field_70146_Z.nextInt(9) == 0;
        return this.getContainer().getVariantForName(this.field_70146_Z.nextInt(4) + 1 + (isChristmasSeason && redNosed ? "_christmas" : ""));
    }

    public boolean func_213397_c(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityReindeer getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainerBAP<EntityReindeer> getContainer() {
        return ModEntities.REINDEER;
    }

    @Override
    public void doHeadDrop() {
        this.getHeadType().drop((MobEntity)this, 12, Optional.of(this.getContainer().getVariantForName(this.getVariantNameOrEmpty().substring(0, 1))));
    }
}

