/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class CarverUtils {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState SAND = Blocks.field_150354_m.func_176223_P();
    private static final BlockState RED_SAND = Blocks.field_196611_F.func_176223_P();
    private static final BlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private static final BlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    private static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private static final BlockState ANDESITE = Blocks.field_196656_g.func_176223_P();
    public static Set<Block> carvableBlocks = ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_196650_c, (Object)Blocks.field_196654_e, (Object)Blocks.field_196656_g, (Object)Blocks.field_150346_d, (Object)Blocks.field_196660_k, (Object[])new Block[]{Blocks.field_196661_l, Blocks.field_196658_i, Blocks.field_150405_ch, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150391_bh, Blocks.field_150433_aE, Blocks.field_150403_cj});
    public static Set<Block> liquidCarvableBlocks = ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_196650_c, (Object)Blocks.field_196654_e, (Object)Blocks.field_196656_g, (Object)Blocks.field_150346_d, (Object)Blocks.field_196660_k, (Object[])new Block[]{Blocks.field_196661_l, Blocks.field_196658_i, Blocks.field_150405_ch, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150391_bh, Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_150343_Z, Blocks.field_150350_a, Blocks.field_201941_jj, Blocks.field_150403_cj});
    private static final ImmutableSet<BlockState> DEBUG_BLOCKS = ImmutableSet.of((Object)Blocks.field_150340_R.func_176223_P(), (Object)Blocks.field_196662_n.func_176223_P(), (Object)Blocks.field_150347_e.func_176223_P(), (Object)Blocks.field_150451_bX.func_176223_P(), (Object)Blocks.field_150475_bE.func_176223_P(), (Object)Blocks.field_196584_bK.func_176223_P(), (Object[])new BlockState[0]);

    private CarverUtils() {
    }

    public static void carveBlock(IChunk chunkIn, BlockPos blockPos, BlockState airBlockState, BlockState liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        int bitIndex = blockPos.func_177958_n() & 0xF | (blockPos.func_177952_p() & 0xF) << 4 | blockPos.func_177956_o() << 8;
        carvingMask.set(bitIndex);
        BlockPos blockPosAbove = blockPos.func_177984_a();
        BlockPos blockPosBelow = blockPos.func_177977_b();
        Biome biome = chunkIn.func_225549_i_().func_225526_b_(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        BlockState biomeTopBlockState = biome.func_203944_q().func_204108_a();
        BlockState biomeFillerBlockState = biome.func_203944_q().func_204109_b();
        BlockState blockState = chunkIn.func_180495_p(blockPos);
        BlockState blockStateAbove = chunkIn.func_180495_p(blockPosAbove);
        BlockState blockStateBelow = chunkIn.func_180495_p(blockPosBelow);
        if (!CarverUtils.canReplaceBlock(blockState, blockStateAbove) && blockState != biomeTopBlockState && blockState != biomeFillerBlockState) {
            return;
        }
        if (airBlockState == CAVE_AIR && blockPos.func_177956_o() <= liquidAltitude) {
            if (liquidBlockState != null) {
                chunkIn.func_177436_a(blockPos, liquidBlockState, false);
            }
        } else {
            if (airBlockState == CAVE_AIR && CarverUtils.isWaterAdjacent(chunkIn, blockPos)) {
                return;
            }
            if (blockState == biomeTopBlockState && CarverUtils.canReplaceBlock(blockStateBelow, CAVE_AIR)) {
                chunkIn.func_177436_a(blockPosBelow, biomeTopBlockState, false);
            }
            if (blockStateAbove == SAND) {
                chunkIn.func_177436_a(blockPosAbove, SANDSTONE, false);
            } else if (blockStateAbove == RED_SAND) {
                chunkIn.func_177436_a(blockPosAbove, RED_SANDSTONE, false);
            }
            if (replaceGravel && blockStateAbove == GRAVEL) {
                chunkIn.func_177436_a(blockPosAbove, ANDESITE, false);
            }
            chunkIn.func_177436_a(blockPos, airBlockState, false);
        }
    }

    public static void carveBlock(IChunk chunkIn, BlockPos blockPos, BlockState liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        CarverUtils.carveBlock(chunkIn, blockPos, Blocks.field_201941_jj.func_176223_P(), liquidBlockState, liquidAltitude, replaceGravel, carvingMask);
    }

    public static void carveBlock(IChunk chunkIn, int x, int y, int z, BlockState liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        CarverUtils.carveBlock(chunkIn, new BlockPos(x, y, z), Blocks.field_201941_jj.func_176223_P(), liquidBlockState, liquidAltitude, replaceGravel, carvingMask);
    }

    public static void carveBlock(IChunk chunkIn, int x, int y, int z, BlockState airBlockState, BlockState liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        CarverUtils.carveBlock(chunkIn, new BlockPos(x, y, z), airBlockState, liquidBlockState, liquidAltitude, replaceGravel, carvingMask);
    }

    public static void carveFloodedBlock(IChunk chunkIn, Random rand, BlockPos.Mutable blockPos, BlockState liquidBlockState, int liquidAltitude, boolean replaceGravel, BitSet carvingMask) {
        int bitIndex = blockPos.func_177958_n() & 0xF | (blockPos.func_177952_p() & 0xF) << 4 | blockPos.func_177956_o() << 8;
        carvingMask.set(bitIndex);
        Biome biome = chunkIn.func_225549_i_().func_225526_b_(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        BlockState biomeTopBlockState = biome.func_203944_q().func_204108_a();
        BlockState biomeFillerBlockState = biome.func_203944_q().func_204109_b();
        BlockState blockState = chunkIn.func_180495_p((BlockPos)blockPos);
        BlockState blockStateAbove = chunkIn.func_180495_p(blockPos.func_177984_a());
        if (!CarverUtils.canReplaceLiquidBlock(blockState, blockStateAbove) && blockState != biomeTopBlockState && blockState != biomeFillerBlockState) {
            return;
        }
        if (blockPos.func_177956_o() == liquidAltitude + 1) {
            float f = rand.nextFloat();
            if (f < 0.25f) {
                chunkIn.func_177436_a((BlockPos)blockPos, Blocks.field_196814_hQ.func_176223_P(), false);
                chunkIn.func_205218_i_().func_205360_a((BlockPos)blockPos, (Object)Blocks.field_196814_hQ, 0);
            } else {
                chunkIn.func_177436_a((BlockPos)blockPos, Blocks.field_150343_Z.func_176223_P(), false);
            }
        } else if (blockPos.func_177956_o() <= liquidAltitude) {
            if (liquidBlockState != null) {
                chunkIn.func_177436_a((BlockPos)blockPos, liquidBlockState, false);
            }
        } else {
            chunkIn.func_177436_a((BlockPos)blockPos, WATER.getBlockState(), false);
            if (replaceGravel && blockStateAbove == GRAVEL) {
                chunkIn.func_177436_a(blockPos.func_177984_a(), ANDESITE, false);
            }
        }
    }

    public static void carveFloodedBlock(IChunk chunkIn, Random rand, BlockPos.Mutable blockPos, BlockState liquidBlockState, int liquidAltitude, BitSet carvingMask) {
        CarverUtils.carveFloodedBlock(chunkIn, rand, blockPos, liquidBlockState, liquidAltitude, false, carvingMask);
    }

    public static void debugCarveBlock(IChunk chunkIn, BlockPos blockPos, BlockState blockState, boolean digBlock) {
        if (DEBUG_BLOCKS.contains((Object)chunkIn.func_180495_p(blockPos))) {
            return;
        }
        if (digBlock) {
            chunkIn.func_177436_a(blockPos, blockState, false);
        } else {
            chunkIn.func_177436_a(blockPos, Blocks.field_150350_a.func_176223_P(), false);
        }
    }

    public static void debugCarveBlock(IChunk chunkIn, int x, int y, int z, BlockState blockState, boolean digBlock) {
        CarverUtils.debugCarveBlock(chunkIn, new BlockPos(x, y, z), blockState, digBlock);
    }

    public static boolean canReplaceBlock(BlockState blockState, BlockState blockStateAbove) {
        Block block = blockState.func_177230_c();
        if (blockState.func_185904_a() == Material.field_151584_j || blockState.func_185904_a() == Material.field_151575_d) {
            return false;
        }
        if (blockStateAbove.func_185904_a() == Material.field_151575_d) {
            return false;
        }
        if (block == Blocks.field_150458_ak || block == Blocks.field_185774_da) {
            return false;
        }
        if (blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151571_B || blockState.func_185904_a() == Material.field_151578_c) {
            return true;
        }
        if (carvableBlocks.contains(block)) {
            return true;
        }
        return (block == Blocks.field_150354_m || block == Blocks.field_150351_n) && blockStateAbove.func_185904_a() != Material.field_151586_h;
    }

    public static boolean canReplaceLiquidBlock(BlockState blockState, BlockState blockStateAbove) {
        Block block = blockState.func_177230_c();
        if (blockState.func_185904_a() == Material.field_151584_j || blockState.func_185904_a() == Material.field_151575_d) {
            return false;
        }
        if (blockStateAbove.func_185904_a() == Material.field_151575_d) {
            return false;
        }
        if (block == Blocks.field_150458_ak || block == Blocks.field_185774_da) {
            return false;
        }
        if (blockState.func_185904_a() == Material.field_151576_e) {
            return true;
        }
        return liquidCarvableBlocks.contains(block);
    }

    private static boolean isWaterAdjacent(IChunk chunkIn, BlockPos blockPos) {
        int localX = BetterCavesUtils.getLocal(blockPos.func_177958_n());
        int localZ = BetterCavesUtils.getLocal(blockPos.func_177952_p());
        int y = blockPos.func_177956_o();
        return y < 255 && chunkIn.func_180495_p(blockPos.func_177984_a()).func_185904_a() == Material.field_151586_h || localZ > 0 && chunkIn.func_180495_p(blockPos.func_177978_c()).func_185904_a() == Material.field_151586_h || localX < 15 && chunkIn.func_180495_p(blockPos.func_177974_f()).func_185904_a() == Material.field_151586_h || localZ < 15 && chunkIn.func_180495_p(blockPos.func_177968_d()).func_185904_a() == Material.field_151586_h || localX > 0 && chunkIn.func_180495_p(blockPos.func_177976_e()).func_185904_a() == Material.field_151586_h;
    }
}

