/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterping.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPingHandler {
    @SubscribeEvent
    public void onRenderGuiPre(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            ScoreObjective scoreobjective = mc.field_71441_e.func_96441_U().func_96539_a(0);
            NetHandlerPlayClient handler = mc.field_71439_g.field_71174_a;
            ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int width = res.func_78326_a();
            if (!mc.func_71387_A() || handler.field_147303_b.size() > 1 || scoreobjective != null) {
                int maxPlayers;
                mc.field_71424_I.func_76320_a("playerList");
                List players = handler.field_147303_b;
                int rows = maxPlayers = handler.field_147304_c;
                int columns = 1;
                columns = 1;
                while (rows > 20) {
                    rows = (maxPlayers + ++columns - 1) / columns;
                }
                int columnWidth = 300 / columns;
                if (columnWidth > 150) {
                    columnWidth = 150;
                }
                int left = (width - columns * columnWidth) / 2;
                int border = 10;
                Gui.func_73734_a((int)(left - 1), (int)(border - 1), (int)(left + columnWidth * columns), (int)(border + 9 * rows), (int)Integer.MIN_VALUE);
                for (int i = 0; i < maxPlayers; ++i) {
                    int endX;
                    int maxX;
                    int xPos = left + i % columns * columnWidth;
                    int yPos = border + i / columns * 9;
                    Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + columnWidth - 1), (int)(yPos + 8), (int)0x20FFFFFF);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3008);
                    if (i >= players.size()) continue;
                    GuiPlayerInfo player = (GuiPlayerInfo)players.get(i);
                    ScorePlayerTeam team = mc.field_71441_e.func_96441_U().func_96509_i(player.field_78831_a);
                    String displayName = ScorePlayerTeam.func_96667_a((Team)team, (String)player.field_78831_a);
                    mc.field_71466_p.func_78261_a(displayName, xPos, yPos, 0xFFFFFF);
                    int ping = player.field_78829_b;
                    String str = ping + "ms";
                    int strWidth = mc.field_71466_p.func_78256_a(str);
                    mc.field_71466_p.func_78261_a(str, xPos + columnWidth - 18 - strWidth, yPos, 0xFFFFFF);
                    if (scoreobjective != null && (maxX = xPos + columnWidth - 12 - 5) - (endX = xPos + mc.field_71466_p.func_78256_a(displayName) + 5) > 5) {
                        Score score = scoreobjective.func_96682_a().func_96529_a(player.field_78831_a, scoreobjective);
                        String scoreDisplay = EnumChatFormatting.YELLOW + "" + score.func_96652_c();
                        mc.field_71466_p.func_78261_a(scoreDisplay, maxX - mc.field_71466_p.func_78256_a(scoreDisplay), yPos, 0xFFFFFF);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                    int pingIndex = 4;
                    if (ping < 0) {
                        pingIndex = 5;
                    } else if (ping < 150) {
                        pingIndex = 0;
                    } else if (ping < 300) {
                        pingIndex = 1;
                    } else if (ping < 600) {
                        pingIndex = 2;
                    } else if (ping < 1000) {
                        pingIndex = 3;
                    }
                    RenderPingHandler.drawTexturedModalRect(xPos + columnWidth - 12, yPos, 0, 176 + pingIndex * 8, 10, 8, 100);
                }
            }
        }
    }

    private static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)zLevel, (double)((float)(u + width) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)x, (double)(y + 0), (double)zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }
}

