/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.biomegrowthcontrol;

import com.lothrazar.biomegrowthcontrol.ModConfig;
import com.lothrazar.biomegrowthcontrol.ModSaplings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GrowthHandler {
    @SubscribeEvent
    public void onFarmlandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
    }

    @SubscribeEvent
    public void onCropGrowEvent(BlockEvent.CropGrowEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (pos == null || world.func_175623_d(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Biome biome = world.func_180494_b(pos);
        try {
            if (!ModConfig.isAllowedToGrow(biome, state)) {
                if (block == Blocks.field_185765_cR && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_185766_cS) {
                    world.func_175655_b(pos.func_177984_a(), ModConfig.dropBlockOnGrowDeny());
                    world.func_175655_b(pos, false);
                }
                event.setResult(Event.Result.DENY);
                if (ModConfig.dropBlockOnGrowDeny()) {
                    world.func_175655_b(pos, true);
                }
            }
        }
        catch (Throwable e) {
            ModSaplings.logger.error("sapling event ", e);
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        ModSaplings.log("Growth event " + pos + " " + block.func_149732_F());
        Biome biome = world.func_180494_b(pos);
        try {
            if (!ModConfig.isAllowedToGrow(biome, state)) {
                event.setResult(Event.Result.DENY);
                if (ModConfig.dropBlockOnGrowDeny()) {
                    world.func_175655_b(pos, true);
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        catch (Throwable e) {
            ModSaplings.logger.error("sapling event ", e);
        }
    }
}

