/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.biomegrowthcontrol;

import com.lothrazar.biomegrowthcontrol.ModSaplings;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;

public class ModConfig {
    private static final String oak = "minecraft:sapling:0";
    private static final String spruce = "minecraft:sapling:1";
    private static final String birch = "minecraft:sapling:2";
    private static final String jungle = "minecraft:sapling:3";
    private static final String acacia = "minecraft:sapling:4";
    private static final String darkoak = "minecraft:sapling:5";
    static String hillsSet = String.join((CharSequence)",", "minecraft:sapling:1", "minecraft:potatoes");
    static String forestSet = String.join((CharSequence)",", "minecraft:sapling:0", "minecraft:pumkpin_stem");
    static String jungleSet = String.join((CharSequence)",", "minecraft:sapling:3", "minecraft:melon_stem", "minecraft:cocoa");
    static String plainsSet = String.join((CharSequence)",", "minecraft:wheat", "minecraft:carrots");
    static String desertSet = String.join((CharSequence)",", "minecraft:cactus");
    static String riverBeachSet = String.join((CharSequence)",", "minecraft:reeds");
    static String endSet = String.join((CharSequence)",", "minecraft:chorus_flower", "minecraft:chorus_plant", "endercrop:ender_crop");
    private static boolean logSpamEverything;
    static Map<String, String[]> biomeAllows;
    private static boolean dropBlockOnDeny;

    public static boolean spam() {
        return logSpamEverything;
    }

    public static void loadConfig(Configuration config) {
        String[] mapListRaw;
        config.load();
        String category = "biomegrowthcontrol";
        logSpamEverything = config.getBoolean("logSpamEverything", category, false, "If true, lots of events and data are logged.  Useful for debugging config values and building modpacks.  ");
        dropBlockOnDeny = config.getBoolean("dropBlockOnDeny", category, true, "If true, then whenever sapling growth is denied it tries to drop the plant as an item.  Does not work on crops or every single block.");
        String[] defaultValues = new String[]{"minecraft:hell#", "minecraft:sky#" + endSet, "minecraft:forest#" + forestSet, "minecraft:forest_hills#" + forestSet, "minecraft:swampland#minecraft:sapling:0", "minecraft:smaller_extreme_hills#" + hillsSet, "minecraft:extreme_hills_with_trees#" + hillsSet, "minecraft:extreme_hills#" + hillsSet, "minecraft:taiga#minecraft:sapling:1", "minecraft:taiga_hills#minecraft:sapling:1", "minecraft:redwood_taiga#" + String.join((CharSequence)",", spruce, darkoak), "minecraft:redwood_taiga_hills#" + String.join((CharSequence)",", spruce, darkoak), "minecraft:jungle#" + jungleSet, "minecraft:jungle_hills#" + jungleSet, "minecraft:jungle_edge#" + jungleSet, "minecraft:birch_forest#minecraft:sapling:2", "minecraft:birch_forest_hills#minecraft:sapling:2", "minecraft:roofed_forest#minecraft:sapling:5", "minecraft:savanna#minecraft:sapling:4", "minecraft:savanna_rock#minecraft:sapling:4", "minecraft:mesa#minecraft:sapling:4", "minecraft:mesa_rock#minecraft:sapling:4", "minecraft:mesa_clear_rock#minecraft:sapling:4", "minecraft:plains#" + plainsSet, "minecraft:desert#" + desertSet, "minecraft:desert_hills#" + desertSet, "minecraft:river#" + riverBeachSet, "minecraft:stone_beach#" + riverBeachSet, "minecraft:beaches#" + riverBeachSet, "minecraft:cold_beach#", "minecraft:frozen_river#", "minecraft:ice_flats#", "minecraft:ice_mountains#", "minecraft:mushroom_island#", "minecraft:mushroom_island_shore#", "minecraft:taiga_cold#" + String.join((CharSequence)",", "minecraft:beetroots"), "minecraft:taiga_cold_hills#" + String.join((CharSequence)",", "minecraft:beetroots"), "minecraft:ocean#", "minecraft:frozen_ocean#", "minecraft:deep_ocean#"};
        for (String s : mapListRaw = config.getStringList("biome sapling map", category, defaultValues, "entry must be 'biome#list,of,sapling,item,ids'.  An empty entry for a biome means all saplings disabled in this biome.  No entry for a biome means no changes for that biome, this mod ignores it.  Biome IDs must be unique, if the same one is listed twice it might probably take the second.  Sapling meta example: 0=oak,1=spruce,2=birch,3=jungle,4=acacia,5=darkoak")) {
            try {
                String[] temp = s.split("#");
                String biomeId = temp[0];
                if (temp.length == 1) continue;
                biomeAllows.put(biomeId, new String[0]);
                String stringCsv = temp[1];
                if (stringCsv == null || stringCsv.isEmpty()) continue;
                String[] saplingCsv = stringCsv.split(",");
                biomeAllows.put(biomeId, saplingCsv);
            }
            catch (Throwable e) {
                ModSaplings.logger.error(s + "  Error on config parse, format must be like 'minecraft:beaches#minecraft:sapling:0,minecraft:sapling:1'");
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isAllowedToGrow(Biome biome, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (state.func_177230_c() == Blocks.field_150345_g) {
            int growthData = 8;
            meta -= growthData;
        }
        String blockId = state.func_177230_c().getRegistryName().toString();
        String blockIdWithMeta = blockId + ":" + meta;
        String biomeId = biome.getRegistryName().toString();
        ModSaplings.log(biomeId + "  containsKey  " + biomeAllows.containsKey(biomeId));
        if (biomeAllows.containsKey(biomeId) && biomeAllows.get(biomeId) != null) {
            String[] blocksAllowed = biomeAllows.get(biomeId);
            ModSaplings.log(biomeId + " blocksAllowed = " + blocksAllowed.length);
            for (String sapling : blocksAllowed) {
                if (!blockId.equals(sapling) && !blockIdWithMeta.equals(sapling)) continue;
                ModSaplings.log(blockIdWithMeta + " allowed at " + biomeId);
                return true;
            }
        } else {
            ModSaplings.log(biomeId + "  has NO ENTRIES, so allow everything " + biomeAllows.get(biomeId));
            return true;
        }
        ModSaplings.log(blockIdWithMeta + " NOT allowed at " + biomeId);
        return false;
    }

    public static void dump() {
        for (String val : biomeAllows.keySet()) {
            System.out.println(val + " ?  " + biomeAllows.get(val).length);
        }
    }

    public static boolean dropBlockOnGrowDeny() {
        return dropBlockOnDeny;
    }

    static {
        biomeAllows = new HashMap<String, String[]>();
    }
}

