/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.util;

import biomesoplenty.client.util.BiomeMapColours;
import java.nio.IntBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

public class GenLayerVisualizer {
    private static VisualizerThread visualizerThread;

    public static void run() {
        visualizerThread = new VisualizerThread();
        visualizerThread.start();
    }

    private static class VisualizerThread
    extends Thread {
        private static final int WINDOW_WIDTH = 1000;
        private static final int WINDOW_HEIGHT = 1000;
        private static final int CANVAS_WIDTH = 100;
        private static final int CANVAS_HEIGHT = 100;
        private static final String VERTEX_SHADER_SRC = "#version 330\nlayout(location = 0) in vec3 position;\nlayout(location = 1) in vec2 vertexUV;\nout vec2 uv;\nvoid main()\n{\n   gl_Position.xyz = position;\n   gl_Position.w = 1.0;\n   uv = vertexUV;\n}";
        private static final String FRAGMENT_SHADER_SRC = "#version 330\nin vec2 uv;\nout vec3 color;\nuniform sampler2D sampler;\nvoid main()\n{\n   color = texture(sampler, uv).rgb;\n}";
        int[] biomeIds = new int[10000];
        private int vertexBuffer = 0;
        private int textureId = 0;

        private VisualizerThread() {
        }

        private void setupOpenGL() {
            GL.createCapabilities();
            GL20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            int vertexArray = GL30.glGenVertexArrays();
            int programId = GL20.glCreateProgram();
            GL30.glBindVertexArray((int)vertexArray);
            int vertexShader = VisualizerThread.makeShader(35633, VERTEX_SHADER_SRC);
            int fragmentShader = VisualizerThread.makeShader(35632, FRAGMENT_SHADER_SRC);
            GL20.glAttachShader((int)programId, (int)vertexShader);
            GL20.glAttachShader((int)programId, (int)fragmentShader);
            GL20.glLinkProgram((int)programId);
            GL20.glUseProgram((int)programId);
            int[] linked = new int[1];
            GL20.glGetProgramiv((int)programId, (int)35714, (int[])linked);
            if (linked[0] == 0) {
                throw new RuntimeException("Failed to link shaders! " + GL20.glGetProgramInfoLog((int)programId));
            }
            GL20.glDetachShader((int)programId, (int)vertexShader);
            GL20.glDetachShader((int)programId, (int)fragmentShader);
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
            float[] VERTICES = new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
            this.vertexBuffer = GL20.glGenBuffers();
            GL20.glBindBuffer((int)34962, (int)this.vertexBuffer);
            GL20.glBufferData((int)34962, (float[])VERTICES, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (long)72L);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            this.textureId = GL20.glGenTextures();
            GL13.glActiveTexture((int)33984);
            GL20.glBindTexture((int)3553, (int)this.textureId);
            GL20.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL20.glTexParameteri((int)3553, (int)10241, (int)9728);
        }

        private void populateBiomeIds() {
        }

        private int getColourForBiomeId(int biomeId, BlockPos pos) {
            return BiomeMapColours.getBiomeMapColour(biomeId);
        }

        private void genTexture() {
            int[] textureColours = new int[10000];
            for (int x = 0; x < 100; ++x) {
                for (int y = 0; y < 100; ++y) {
                    int color = this.getColourForBiomeId(this.biomeIds[x + y * 100], new BlockPos(x, 0, y));
                    textureColours[x + (99 - y) * 100] = color = color >> 16 & 0xFF | color & 0xFF00 | color << 16 & 0xFF0000;
                }
            }
            GL20.glBindTexture((int)3553, (int)this.textureId);
            GL20.glTexImage2D((int)3553, (int)0, (int)6408, (int)100, (int)100, (int)0, (int)6408, (int)5121, (int[])textureColours);
        }

        @Override
        public void run() {
            long window = GLFW.glfwCreateWindow((int)1000, (int)1000, (CharSequence)"Gen Layer Visualizer", (long)0L, (long)0L);
            if (window == 0L) {
                throw new RuntimeException("Failed to create the GLFW window");
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer pWidth = stack.mallocInt(1);
                IntBuffer pHeight = stack.mallocInt(1);
                GLFW.glfwGetWindowSize((long)window, (IntBuffer)pWidth, (IntBuffer)pHeight);
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
                GLFW.glfwSetWindowPos((long)window, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
            }
            GLFW.glfwMakeContextCurrent((long)window);
            GLFW.glfwSwapInterval((int)1);
            GLFW.glfwShowWindow((long)window);
            this.setupOpenGL();
            this.populateBiomeIds();
            while (!GLFW.glfwWindowShouldClose((long)window)) {
                GL11.glClear((int)16640);
                this.genTexture();
                GL20.glDrawArrays((int)4, (int)0, (int)6);
                GLFW.glfwSwapBuffers((long)window);
                GLFW.glfwPollEvents();
            }
        }

        private static int makeShader(int type, String source) {
            int shader = GL20.glCreateShader((int)type);
            GL20.glShaderSource((int)shader, (CharSequence)source);
            GL20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GL20.glGetShaderiv((int)shader, (int)35713, (int[])compiled);
            if (compiled[0] == 0) {
                throw new RuntimeException("Failed to compile shader! " + GL20.glGetShaderInfoLog((int)shader));
            }
            return shader;
        }

        private static boolean isOcean(Biome biome) {
            return biome == Biomes.field_203614_T || biome == Biomes.field_203615_U || biome == Biomes.field_76771_b || biome == Biomes.field_203616_V || biome == Biomes.field_76776_l || biome == Biomes.field_203617_W || biome == Biomes.field_203618_X || biome == Biomes.field_150575_M || biome == Biomes.field_203619_Y || biome == Biomes.field_203620_Z;
        }
    }
}

