/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.BOPBiomeProvider;
import biomesoplenty.common.world.BOPDimensionType;
import biomesoplenty.common.world.BOPNetherBiomeProvider;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.ServerWorldInfo;

public class BOPWorldTypeUtil {
    private static boolean isServerLevelTypeBop(DedicatedServer server) {
        String levelType = Optional.ofNullable((String)server.func_213221_d_().field_73672_b.get("level-type")).map(str -> str.toLowerCase(Locale.ROOT)).orElse("default");
        return levelType.equals("biomesoplenty") || levelType.equals("biomesop");
    }

    public static boolean isUsingBopWorldType(DimensionGeneratorSettings settings) {
        ArrayList dimensions = Lists.newArrayList((Iterable)settings.func_236224_e_().func_239659_c_());
        Map.Entry dimensionEntry0 = (Map.Entry)dimensions.get(0);
        Map.Entry dimensionEntry1 = (Map.Entry)dimensions.get(1);
        Map.Entry dimensionEntry2 = (Map.Entry)dimensions.get(2);
        if (dimensionEntry0.getKey() != Dimension.field_236053_b_ || dimensionEntry1.getKey() != Dimension.field_236054_c_ && dimensionEntry2.getKey() != Dimension.field_236055_d_) {
            return false;
        }
        Dimension overworld = (Dimension)dimensionEntry0.getValue();
        Dimension nether = (Dimension)dimensionEntry1.getValue();
        Dimension end = (Dimension)dimensionEntry2.getValue();
        if (!(overworld.func_236064_c_() instanceof NoiseChunkGenerator && nether.func_236064_c_() instanceof NoiseChunkGenerator && end.func_236064_c_() instanceof NoiseChunkGenerator)) {
            return false;
        }
        return overworld.func_236064_c_().func_202090_b() instanceof BOPBiomeProvider && nether.func_236064_c_().func_202090_b() instanceof BOPNetherBiomeProvider;
    }

    public static ChunkGenerator createChunkGenerator(long seed) {
        return new NoiseChunkGenerator((BiomeProvider)new BOPBiomeProvider(seed), seed, DimensionSettings.Preset.field_236122_b_.func_236137_b_());
    }

    public static DimensionGeneratorSettings createDimensionGeneratorSettings(long seed, boolean generateFeatures, boolean generateBonusChest) {
        return new DimensionGeneratorSettings(seed, generateFeatures, generateBonusChest, DimensionGeneratorSettings.func_236216_a_(BOPDimensionType.bopDimensions(seed), (ChunkGenerator)BOPWorldTypeUtil.createChunkGenerator(seed)));
    }

    public static void setupForDedicatedServer(DedicatedServer server) {
        if (!BOPWorldTypeUtil.isServerLevelTypeBop(server)) {
            return;
        }
        ServerProperties properties = server.func_213221_d_();
        DimensionGeneratorSettings oldWorldGenSettings = properties.field_241082_U_;
        long seed = oldWorldGenSettings.func_236221_b_();
        boolean generateFeatures = oldWorldGenSettings.func_236222_c_();
        boolean generateBonusChest = oldWorldGenSettings.func_236223_d_();
        BiomesOPlenty.logger.info("Setting world generator settings to biomesoplenty");
        DimensionGeneratorSettings newWorldGenSettings = BOPWorldTypeUtil.createDimensionGeneratorSettings(seed, generateFeatures, generateBonusChest);
        if (server.func_240793_aU_() instanceof ServerWorldInfo) {
            ServerWorldInfo worldInfo = (ServerWorldInfo)server.func_240793_aU_();
            worldInfo.field_237343_c_ = newWorldGenSettings;
        }
        properties.field_241082_U_ = newWorldGenSettings;
    }
}

