/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraftforge.common.IPlantable;

public class BasicTreeFeature
extends TreeFeatureBase {
    protected int leafLayers;
    protected int leavesOffset;
    protected int maxLeavesRadius;
    protected int leavesLayerHeight;
    protected IBlockPosQuery placeVinesOn;
    protected float hangingChance;

    protected BasicTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int leafLayers, int leavesOffset, int maxLeavesRadius, int leavesLayerHeight, IBlockPosQuery placeVinesOn, float hangingChance) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.leafLayers = leafLayers;
        this.leavesOffset = leavesOffset;
        this.maxLeavesRadius = maxLeavesRadius;
        this.leavesLayerHeight = leavesLayerHeight;
        this.placeVinesOn = placeVinesOn;
        this.hangingChance = hangingChance;
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos pos, MutableBoundingBox boundingBox) {
        int height = random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        boolean hasSpace = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.func_177956_o()) {
                    radius = 0;
                }
                if (y >= pos.func_177956_o() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius && hasSpace; ++x) {
                    for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius && hasSpace; ++z) {
                        if (y >= 0 && y < 256) {
                            if (this.replace.matches(world, new BlockPos(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            BlockPos soilPos = pos.func_177977_b();
            Block soil = world.func_180495_p(soilPos).func_177230_c();
            boolean isSoil = soil.canSustainPlant(world.func_180495_p(soilPos), (IBlockReader)world, soilPos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t));
            if (this.placeOn.matches(world, soilPos) && isSoil && pos.func_177956_o() < 256 - height - 1) {
                int x;
                int leavesRadius;
                int currentLayer;
                int y;
                soil.onPlantGrow(world.func_180495_p(soilPos), world, soilPos, pos);
                int leavesLayers = this.leafLayers - 1;
                for (y = pos.func_177956_o() + height - leavesLayers; y <= pos.func_177956_o() + height; ++y) {
                    currentLayer = y - (pos.func_177956_o() + height);
                    leavesRadius = this.maxLeavesRadius - currentLayer / this.leavesLayerHeight;
                    for (x = pos.func_177958_n() - leavesRadius; x <= pos.func_177958_n() + leavesRadius; ++x) {
                        int xDiff = x - pos.func_177958_n();
                        for (int z = pos.func_177952_p() - leavesRadius; z <= pos.func_177952_p() + leavesRadius; ++z) {
                            BlockPos leavesPos;
                            int zDiff = z - pos.func_177952_p();
                            if (Math.abs(xDiff) == leavesRadius && Math.abs(zDiff) == leavesRadius && (random.nextInt(2) == 0 || currentLayer == 0) || !this.replace.matches(world, leavesPos = new BlockPos(x, y, z))) continue;
                            if (this.altLeaves != Blocks.field_150350_a.func_176223_P()) {
                                if (random.nextInt(4) == 0) {
                                    this.setAltLeaves(world, leavesPos, changedLeaves, boundingBox);
                                    continue;
                                }
                                this.placeLeaves(world, leavesPos, changedLeaves, boundingBox);
                                continue;
                            }
                            this.placeLeaves(world, leavesPos, changedLeaves, boundingBox);
                        }
                    }
                }
                this.generateTrunk(changedLogs, boundingBox, world, pos, height);
                if (this.vine != Blocks.field_150350_a.func_176223_P()) {
                    for (y = pos.func_177956_o() - leavesLayers + height; y <= pos.func_177956_o() + height; ++y) {
                        currentLayer = y - (pos.func_177956_o() + height);
                        leavesRadius = this.maxLeavesRadius + this.leavesOffset - currentLayer / this.leavesLayerHeight;
                        for (x = pos.func_177958_n() - leavesRadius; x <= pos.func_177958_n() + leavesRadius; ++x) {
                            for (int z = pos.func_177952_p() - leavesRadius; z <= pos.func_177952_p() + leavesRadius; ++z) {
                                BlockPos blockpos3 = new BlockPos(x, y, z);
                                if (world.func_180495_p(blockpos3).func_185904_a() != Material.field_151584_j) continue;
                                BlockPos westPos = blockpos3.func_177976_e();
                                BlockPos eastPos = blockpos3.func_177974_f();
                                BlockPos northPos = blockpos3.func_177978_c();
                                BlockPos southPos = blockpos3.func_177968_d();
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, westPos)) {
                                    this.extendVines(world, westPos, Direction.EAST);
                                }
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, eastPos)) {
                                    this.extendVines(world, eastPos, Direction.WEST);
                                }
                                if (random.nextInt(4) == 0 && this.placeVinesOn.matches(world, northPos)) {
                                    this.extendVines(world, northPos, Direction.SOUTH);
                                }
                                if (random.nextInt(4) != 0 || !this.placeVinesOn.matches(world, southPos)) continue;
                                this.extendVines(world, southPos, Direction.NORTH);
                            }
                        }
                    }
                }
                if (this.hanging != Blocks.field_150350_a.func_176223_P()) {
                    this.generateHanging(world, pos, random, height);
                }
                if (this.trunkFruit != Blocks.field_150350_a.func_176223_P() && random.nextInt(5) == 0 && height > 5) {
                    for (int l3 = 0; l3 < 2; ++l3) {
                        for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                            if (random.nextInt(4 - l3) != 0) continue;
                            Direction Direction1 = Direction2.func_176734_d();
                            this.generateTrunkFruit(world, random.nextInt(3), pos.func_177982_a(Direction1.func_82601_c(), height - 5 + l3, Direction1.func_82599_e()), Direction2);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(Set<BlockPos> changedBlocks, MutableBoundingBox boundingBox, IWorld world, BlockPos start, int height) {
        for (int layer = 0; layer < height; ++layer) {
            BlockPos blockpos2 = start.func_177981_b(layer);
            if (!this.replace.matches(world, blockpos2)) continue;
            this.placeLog(world, start.func_177981_b(layer), changedBlocks, boundingBox);
        }
    }

    protected void generateHanging(IWorld world, BlockPos start, Random rand, int height) {
        int y = start.func_177956_o() + (height - this.leafLayers);
        for (int x = start.func_177958_n() - (this.maxLeavesRadius + 1); x <= start.func_177958_n() + (this.maxLeavesRadius + 1); ++x) {
            for (int z = start.func_177952_p() - (this.maxLeavesRadius + 1); z <= start.func_177952_p() + (this.maxLeavesRadius + 1); ++z) {
                BlockPos hangingPos = new BlockPos(x, y, z);
                if (world.func_175623_d(hangingPos.func_177984_a()) || !world.func_175623_d(hangingPos) || !(rand.nextFloat() <= this.hangingChance)) continue;
                this.setHanging(world, hangingPos);
            }
        }
    }

    private void generateTrunkFruit(IWorld world, int age, BlockPos pos, Direction direction) {
        if (this.trunkFruit == Blocks.field_150375_by.func_176223_P()) {
            this.func_230367_a_((IWorldWriter)world, pos, (BlockState)((BlockState)this.trunkFruit.func_206870_a((Property)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age))).func_206870_a((Property)CocoaBlock.field_185512_D, (Comparable)direction));
        } else {
            this.func_230367_a_((IWorldWriter)world, pos, (BlockState)this.trunkFruit.func_206870_a((Property)CocoaBlock.field_185512_D, (Comparable)direction));
        }
    }

    private BlockState getVineStateForSide(Direction side) {
        return this.vine.func_177230_c() instanceof VineBlock ? (BlockState)this.vine.func_206870_a((Property)VineBlock.func_176267_a((Direction)side), (Comparable)Boolean.valueOf(true)) : this.vine;
    }

    private void extendVines(IWorld world, BlockPos pos, Direction side) {
        BlockState vineState = this.getVineStateForSide(side);
        this.func_230367_a_((IWorldWriter)world, pos, vineState);
        pos = pos.func_177977_b();
        for (int length = 4; this.placeVinesOn.matches(world, pos) && length > 0; --length) {
            this.func_230367_a_((IWorldWriter)world, pos, vineState);
            pos = pos.func_177977_b();
        }
    }

    protected static abstract class InnerBuilder<T extends TreeFeatureBase.BuilderBase, F extends TreeFeatureBase>
    extends TreeFeatureBase.BuilderBase<T, F> {
        protected int leafLayers;
        protected int leavesOffset;
        protected int maxLeavesRadius;
        protected int leavesLayerHeight;
        protected IBlockPosQuery placeVinesOn;
        protected float hangingChance;

        public T leafLayers(int a) {
            this.leafLayers = a;
            return (T)this;
        }

        public T leavesOffset(int a) {
            this.leavesOffset = a;
            return (T)this;
        }

        public T leavesLayerHeight(int a) {
            this.leavesLayerHeight = a;
            return (T)this;
        }

        public T maxLeavesRadius(int a) {
            this.maxLeavesRadius = a;
            return (T)this;
        }

        public T placeVinesOn(IBlockPosQuery a) {
            this.placeVinesOn = a;
            return (T)this;
        }

        public T hangingChance(float a) {
            this.hangingChance = a;
            return (T)this;
        }

        public InnerBuilder() {
            this.placeOn = (world, pos) -> world.func_180495_p(pos).func_200132_m();
            this.minHeight = 4;
            this.maxHeight = 7;
            this.leafLayers = 4;
            this.leavesOffset = 1;
            this.maxLeavesRadius = 1;
            this.leavesLayerHeight = 2;
            this.placeVinesOn = (world, pos) -> {
                Material mat = world.func_180495_p(pos).func_185904_a();
                return mat == Material.field_151579_a;
            };
            this.hangingChance = 0.0f;
        }
    }

    public static class Builder
    extends InnerBuilder<Builder, BasicTreeFeature> {
        @Override
        public BasicTreeFeature create() {
            return new BasicTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.leafLayers, this.leavesOffset, this.maxLeavesRadius, this.leavesLayerHeight, this.placeVinesOn, this.hangingChance);
        }
    }
}

