/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicChest;
import net.darkhax.bookshelf.builder.ChestBuilder;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;

public class BlockBasicChest
extends BlockChest {
    private final ChestBuilder builder;

    public BlockBasicChest(ChestBuilder builder, BlockChest.Type type) {
        super(type);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.builder = builder;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        ChestBuilder.IChestType myType = this.getCustomType(source, pos);
        return this.getCustomType(source, pos.func_177978_c()) == myType ? field_185557_b : (this.getCustomType(source, pos.func_177968_d()) == myType ? field_185558_c : (this.getCustomType(source, pos.func_177976_e()) == myType ? field_185559_d : (this.getCustomType(source, pos.func_177974_f()) == myType ? field_185560_e : field_185561_f)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176459_a, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        boolean eastChest;
        EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)field_176459_a, (Comparable)facing);
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        BlockPos westPos = pos.func_177976_e();
        BlockPos eastPos = pos.func_177974_f();
        ChestBuilder.IChestType myType = this.getCustomType(stack);
        boolean northChest = myType == this.getCustomType((IBlockAccess)worldIn, northPos);
        boolean southChest = myType == this.getCustomType((IBlockAccess)worldIn, southPos);
        boolean westChest = myType == this.getCustomType((IBlockAccess)worldIn, westPos);
        boolean bl = eastChest = myType == this.getCustomType((IBlockAccess)worldIn, eastPos);
        if (!(northChest || southChest || westChest || eastChest)) {
            worldIn.func_180501_a(pos, state, 3);
        } else if (facing.func_176740_k() != EnumFacing.Axis.X || !northChest && !southChest) {
            if (facing.func_176740_k() == EnumFacing.Axis.Z && (westChest || eastChest)) {
                if (westChest) {
                    this.setState(worldIn, westPos, state, 3);
                } else {
                    this.setState(worldIn, eastPos, state, 3);
                }
                worldIn.func_180501_a(pos, state, 3);
            } else {
                EnumFacing corrected = facing.func_176746_e();
                this.setState(worldIn, pos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                if (northChest) {
                    this.setState(worldIn, northPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                } else if (southChest) {
                    this.setState(worldIn, southPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                } else if (westChest) {
                    this.setState(worldIn, westPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                } else if (eastChest) {
                    this.setState(worldIn, eastPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                }
            }
        } else {
            if (northChest) {
                this.setState(worldIn, northPos, state, 3);
            } else {
                this.setState(worldIn, southPos, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityBasicChest) {
            TileEntityBasicChest chest = (TileEntityBasicChest)te;
            if (stack.func_82837_s()) {
                chest.func_190575_a(stack.func_82833_r());
            }
            chest.setType(myType);
        }
        this.func_176213_c(worldIn, pos, state);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.isTrapChest();
    }

    @Deprecated
    public IBlockState func_176455_e(World worldIn, BlockPos pos, IBlockState state) {
        return state;
    }

    @Deprecated
    public IBlockState func_176458_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.correctFacing(worldIn, pos, state, ChestBuilder.NONE);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
        if (te instanceof TileEntityBasicChest) {
            te.func_145843_s();
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBasicChest(this.builder);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>(Collections.singletonList(this.setCustomType(new ItemStack((Block)this, 1), this.getCustomType(world, pos))));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.setCustomType(new ItemStack((Block)this, 1), this.getCustomType((IBlockAccess)world, pos));
    }

    public ILockableContainer func_189418_a(World world, BlockPos pos, boolean locked) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityBasicChest)) {
            return null;
        }
        TileEntityBasicChest myChest = (TileEntityBasicChest)tile;
        ChestBuilder.IChestType myType = ((TileEntityBasicChest)tile).getType();
        if (!locked && this.isBlocked(world, pos)) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos adjPos = pos.func_177972_a(facing);
            TileEntity adjTile = world.func_175625_s(adjPos);
            if (world.func_180495_p(adjPos).func_177230_c() != this || !(adjTile instanceof TileEntityBasicChest) || ((TileEntityBasicChest)adjTile).getType() != myType) continue;
            if (this.isBlocked(world, adjPos)) {
                return null;
            }
            if (facing != EnumFacing.WEST && facing != EnumFacing.NORTH) {
                myChest = new InventoryLargeChest("container.chestDouble", (ILockableContainer)myChest, (ILockableContainer)((TileEntityBasicChest)adjTile));
                continue;
            }
            myChest = new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityBasicChest)adjTile), (ILockableContainer)myChest);
        }
        return myChest;
    }

    public boolean isTrapChest() {
        return this.field_149956_a == this.builder.getTrapType();
    }

    public void setState(World worldIn, BlockPos pos, IBlockState state, int flag) {
        TileEntity te = worldIn.func_175625_s(pos);
        worldIn.func_180501_a(pos, state, flag);
        if (te != null) {
            te.func_145829_t();
            worldIn.func_175690_a(pos, te);
            if (te instanceof TileEntityBasicChest) {
                ((TileEntityBasicChest)te).field_145984_a = false;
            }
        }
    }

    public IBlockState correctFacing(World worldIn, BlockPos pos, IBlockState state, ChestBuilder.IChestType myType) {
        EnumFacing facing = null;
        for (EnumFacing horizFace : EnumFacing.Plane.HORIZONTAL) {
            if (this.getCustomType((IBlockAccess)worldIn, pos.func_177972_a(horizFace)) == myType) {
                return state;
            }
            if (!worldIn.func_180495_p(pos.func_177972_a(horizFace)).func_185913_b()) continue;
            if (facing != null) {
                facing = null;
                break;
            }
            facing = horizFace;
        }
        if (facing != null) {
            return state.func_177226_a((IProperty)field_176459_a, (Comparable)facing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)field_176459_a);
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)field_176459_a, (Comparable)enumfacing2);
    }

    public boolean isDoubleChest(World worldIn, BlockPos pos, ChestBuilder.IChestType myType) {
        if (this.getCustomType((IBlockAccess)worldIn, pos) != myType) {
            return false;
        }
        ChestBuilder.IChestType theType = this.getCustomType((IBlockAccess)worldIn, pos);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (this.getCustomType((IBlockAccess)worldIn, pos.func_177972_a(enumfacing)) != theType) continue;
            return true;
        }
        return false;
    }

    public ChestBuilder.IChestType getCustomType(IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (world.func_180495_p(pos).func_177230_c() == this && (te = world.func_175625_s(pos)) instanceof TileEntityBasicChest) {
            return ((TileEntityBasicChest)te).getType();
        }
        return ChestBuilder.NONE;
    }

    public ChestBuilder.IChestType getCustomType(ItemStack stack) {
        NBTTagCompound tag = StackUtils.prepareStackTag(stack);
        return this.builder.getChestType(tag.func_74779_i("type"));
    }

    public ItemStack setCustomType(ItemStack stack, ChestBuilder.IChestType type) {
        NBTTagCompound tag = StackUtils.prepareStackTag(stack);
        tag.func_74778_a("type", type.getName());
        return stack;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (Entity entity : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot cat = (EntityOcelot)entity;
            if (!cat.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public ChestBuilder getBuilder() {
        return this.builder;
    }
}

