/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.block.tileentity;

import net.darkhax.bookshelf.builder.ChestBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityBasicChest
extends TileEntityChest {
    private ChestBuilder builder;
    private ChestBuilder.IChestType type = ChestBuilder.NONE;
    private String typeString = "";

    public TileEntityBasicChest() {
    }

    public TileEntityBasicChest(ChestBuilder builder) {
        this.builder = builder;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("builder", this.builder.getModid());
        nbt.func_74778_a("type", this.type == null ? this.typeString : this.type.getName());
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74778_a("builder", this.builder.getModid());
        nbt.func_74778_a("type", this.type == null ? this.typeString : this.type.getName());
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.builder = ChestBuilder.BUILDERS.get(tag.func_74779_i("builder"));
        this.type = this.builder.getChestType(tag.func_74779_i("type"));
        if (this.type != null) {
            this.typeString = this.type.getName();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("builder", this.builder.getModid());
        nbt.func_74778_a("type", this.type == null ? this.typeString : this.type.getName());
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.builder = ChestBuilder.BUILDERS.get(pkt.func_148857_g().func_74779_i("builder"));
        this.type = this.builder.getChestType(pkt.func_148857_g().func_74779_i("type"));
        if (this.type != null) {
            this.typeString = this.type.getName();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.builder = ChestBuilder.BUILDERS.get(nbt.func_74779_i("builder"));
        this.type = this.builder.getChestType(nbt.func_74779_i("type"));
        if (this.type != null) {
            this.typeString = this.type.getName();
        }
    }

    protected TileEntityChest func_174911_a(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (tileentity = this.func_145831_w().func_175625_s(blockpos)) instanceof TileEntityBasicChest) {
            TileEntityBasicChest tileentitychest = (TileEntityBasicChest)tileentity;
            tileentitychest.setNeighbor(this, side.func_176734_d());
            return tileentitychest;
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public ChestBuilder.IChestType getType() {
        return this.type;
    }

    public void setType(ChestBuilder.IChestType type) {
        this.type = type;
    }

    private boolean isChestAt(BlockPos posIn) {
        if (this.func_145831_w() == null) {
            return false;
        }
        Block block = this.func_145831_w().func_180495_p(posIn).func_177230_c();
        TileEntity te = this.func_145831_w().func_175625_s(posIn);
        return block instanceof BlockChest && ((BlockChest)block).field_149956_a == this.func_145980_j() && te instanceof TileEntityBasicChest && ((TileEntityBasicChest)te).type == this.type;
    }

    private void setNeighbor(TileEntityChest chestTe, EnumFacing side) {
        if (chestTe.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chestTe) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    public ChestBuilder getBuilder() {
        return this.builder;
    }
}

