/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.block.BlockBasicChest;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicChest;
import net.darkhax.bookshelf.client.render.tileentity.TileEntityBasicChestRenderer;
import net.darkhax.bookshelf.item.ItemBlockChest;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.util.GameUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ChestBuilder {
    public static final ResourceLocation TRAP_OVERLAY_SINGLE = new ResourceLocation("bookshelf", "textures/entity/chest/trap.png");
    public static final ResourceLocation TRAP_OVERLAY_DOUBLE = new ResourceLocation("bookshelf", "textures/entity/chest/trap_double.png");
    public static final Map<String, ChestBuilder> BUILDERS = new HashMap<String, ChestBuilder>();
    public static final ChestType NONE = new ChestType("none", "none");
    private static boolean tileRegistered = false;
    private final BlockChest.Type typeNormal;
    private BlockChest.Type typeTrap;
    private final Block chestNormal;
    private Block chestTrap;
    private final String modId;
    private final boolean useTraps;
    private final boolean isXmas;
    private final Map<String, IChestType> types;

    public ChestBuilder(String modid, boolean useTraps) {
        boolean useXmas = false;
        this.modId = modid;
        this.useTraps = useTraps;
        this.isXmas = false;
        this.types = new HashMap<String, IChestType>();
        this.typeNormal = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)modid.toUpperCase(), (Class[])new Class[0], (Object[])new Object[0]);
        this.chestNormal = new BlockBasicChest(this, this.typeNormal);
        if (this.useTraps) {
            this.typeTrap = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)(modid.toUpperCase() + "_TRAP"), (Class[])new Class[0], (Object[])new Object[0]);
            this.chestTrap = new BlockBasicChest(this, this.typeTrap);
        }
        BUILDERS.put(modid, this);
    }

    public void register(RegistryHelper registry) {
        registry.registerBlock(this.chestNormal, new ItemBlockChest(this.chestNormal, this), "chest");
        OreDictionary.registerOre((String)"chest", (ItemStack)new ItemStack(this.chestNormal, 1, Short.MAX_VALUE));
        if (this.useTraps) {
            this.chestTrap = registry.registerBlock(this.chestTrap, new ItemBlockChest(this.chestTrap, this), "chest_trap");
            OreDictionary.registerOre((String)"chest", (ItemStack)new ItemStack(this.chestTrap, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"chestTrapped", (ItemStack)new ItemStack(this.chestTrap, 1, Short.MAX_VALUE));
        }
        this.registerTile();
    }

    private void registerTile() {
        if (tileRegistered) {
            return;
        }
        GameRegistry.registerTileEntity(TileEntityBasicChest.class, (String)"bookshelf_chest");
        if (GameUtils.isClient()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBasicChest.class, (TileEntitySpecialRenderer)new TileEntityBasicChestRenderer());
        }
        tileRegistered = true;
    }

    public Block getNormalChest() {
        return this.chestNormal;
    }

    public Block getTrapChest() {
        return this.chestTrap;
    }

    public void addChestType(String ... names) {
        for (String name : names) {
            this.addChestType(name);
        }
    }

    public IChestType addChestType(String name) {
        IChestType type = this.addChestType(new ChestType(this.modId, name));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.useTraps) {
            type.addRenderHook(RenderTrapChestOverlay.INSTANCE);
        }
        return type;
    }

    public IChestType addChestType(IChestType type) {
        this.types.put(type.getName(), type);
        return type;
    }

    public IChestType getChestType(String name) {
        return this.types.get(name);
    }

    public BlockChest.Type getNormalType() {
        return this.typeNormal;
    }

    public BlockChest.Type getTrapType() {
        return this.typeTrap;
    }

    public Collection<IChestType> getTypes() {
        return this.types.values();
    }

    public String getModid() {
        return this.modId;
    }

    public boolean useTraps() {
        return this.useTraps;
    }

    @SideOnly(value=Side.CLIENT)
    public static interface IRenderHook {
        public void render(TileEntityBasicChest var1, double var2, double var4, double var6, float var8, int var9, TileEntityBasicChestRenderer var10, ModelChest var11, boolean var12);

        public void setup(TileEntityBasicChest var1, double var2, double var4, double var6, float var8, int var9, TileEntityBasicChestRenderer var10, ModelChest var11, boolean var12);
    }

    @SideOnly(value=Side.CLIENT)
    public static class RenderTrapChestOverlay
    implements IRenderHook {
        public static final IRenderHook INSTANCE = new RenderTrapChestOverlay();

        @Override
        public void render(TileEntityBasicChest te, double x, double y, double z, float partialTicks, int destroyStage, TileEntityBasicChestRenderer renderer, ModelChest model, boolean isSingle) {
            if (te.func_145980_j() == te.getBuilder().typeTrap) {
                renderer.func_147499_a(isSingle ? TRAP_OVERLAY_SINGLE : TRAP_OVERLAY_DOUBLE);
                float scale = 1.002f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179152_a((float)1.002f, (float)1.002f, (float)1.002f);
                GlStateManager.func_179109_b((float)(!isSingle ? -0.002f : -0.001f), (float)-0.001f, (float)-0.001f);
                model.func_78231_a();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }

        @Override
        public void setup(TileEntityBasicChest te, double x, double y, double z, float partialTicks, int destroyStage, TileEntityBasicChestRenderer renderer, ModelChest model, boolean isSingle) {
        }
    }

    public static interface IChestType {
        public String getName();

        public String getModId();

        public ResourceLocation getNormalTexture();

        public ResourceLocation getDoubleTexture();

        public ModelResourceLocation getNormalItemModel();

        public ModelResourceLocation getTrapItemModel();

        @SideOnly(value=Side.CLIENT)
        public List<IRenderHook> renderHooks();

        @SideOnly(value=Side.CLIENT)
        public void addRenderHook(IRenderHook var1);
    }

    public static class ChestType
    implements IChestType {
        private final String modid;
        private final String name;
        private final ResourceLocation textureNormal;
        private final ResourceLocation textureDouble;
        private final ModelResourceLocation itemModelChest;
        private final ModelResourceLocation itemModelChestTrap;
        @SideOnly(value=Side.CLIENT)
        private List<IRenderHook> renderHooks;

        public ChestType(String modid, String name) {
            this.modid = modid;
            this.name = name;
            this.textureNormal = new ResourceLocation(modid, "textures/entity/chest/" + name + ".png");
            this.textureDouble = new ResourceLocation(modid, "textures/entity/chest/" + name + "_double.png");
            this.itemModelChest = new ModelResourceLocation(new ResourceLocation(modid, "chest_" + name), "inventory");
            this.itemModelChestTrap = new ModelResourceLocation(new ResourceLocation(modid, "chest_trap_" + name), "inventory");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getModId() {
            return this.modid;
        }

        @Override
        public ResourceLocation getNormalTexture() {
            return this.textureNormal;
        }

        @Override
        public ResourceLocation getDoubleTexture() {
            return this.textureDouble;
        }

        @Override
        public ModelResourceLocation getNormalItemModel() {
            return this.itemModelChest;
        }

        @Override
        public ModelResourceLocation getTrapItemModel() {
            return this.itemModelChestTrap;
        }

        @Override
        public List<IRenderHook> renderHooks() {
            if (this.renderHooks == null) {
                this.renderHooks = new ArrayList<IRenderHook>();
            }
            return this.renderHooks;
        }

        @Override
        public void addRenderHook(IRenderHook callback) {
            if (this.renderHooks == null) {
                this.renderHooks = new ArrayList<IRenderHook>();
            }
            this.renderHooks.add(callback);
        }
    }
}

