/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.builder;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootBuilder {
    private final String name;
    private String pool;
    private int weight;
    private int quality;
    private Item item;
    private final List<LootCondition> conditions;
    private final List<LootFunction> functions;

    public LootBuilder(String name, String pool, int weight, Item item) {
        this(name, pool, weight, 0, item, new ArrayList<LootCondition>(), new ArrayList<LootFunction>());
    }

    public LootBuilder(String name, String pool, int weight, int quality, Item item, List<LootCondition> conditions, List<LootFunction> functions) {
        this.name = name;
        this.pool = pool;
        this.weight = weight;
        this.quality = quality;
        this.item = item;
        this.conditions = conditions;
        this.functions = functions;
    }

    public String getName() {
        return this.name;
    }

    public String getPool() {
        return this.pool;
    }

    public LootBuilder setPool(String pool) {
        this.pool = pool;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public LootBuilder setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public int getQuality() {
        return this.quality;
    }

    public LootBuilder setQuality(int quality) {
        this.quality = quality;
        return this;
    }

    public Item getItem() {
        return this.item;
    }

    public LootBuilder setItem(Item item) {
        this.item = item;
        return this;
    }

    public List<LootCondition> getConditions() {
        return this.conditions;
    }

    public LootBuilder addCondition(LootCondition conditon) {
        this.conditions.add(conditon);
        return this;
    }

    public List<LootFunction> getFunctions() {
        return this.functions;
    }

    public LootBuilder addFunction(LootFunction function) {
        this.functions.add(function);
        return this;
    }

    public LootEntryItem build() {
        return new LootEntryItem(this.item, this.weight, this.quality, this.functions.toArray(new LootFunction[0]), this.conditions.toArray(new LootCondition[0]), this.name);
    }

    public String toString() {
        return String.format("Name: %s - Pool: %s - Weight: %d - Quality: %d Item: %s", this.name, this.pool, this.weight, this.quality, this.item.getRegistryName());
    }
}

