/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.darkhax.bookshelf.client.model.DefaultItemOverrideList;
import net.darkhax.bookshelf.data.Blockstates;
import net.darkhax.bookshelf.util.RenderUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelRetexturable
implements IPerspectiveAwareModel {
    protected final IRetexturableModel baseModel;
    protected final String textureVariable;
    protected final Function<ResourceLocation, TextureAtlasSprite> spriteGetter;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final Map<String, IBakedModel> cache = Maps.newHashMap();
    protected final boolean ambientOcclusion;
    protected final boolean gui3D;
    protected final boolean builtin;
    protected final IBlockState particle;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList itemOverride;
    protected final TextureAtlasSprite defaultSprite;

    public BakedModelRetexturable(IRetexturableModel baseModel, String textureVariable, IBlockState particle, TextureAtlasSprite defaultSprite) {
        this(baseModel, textureVariable, particle, RenderUtils.getBasicTransforms((IPerspectiveAwareModel)baseModel), DefaultItemOverrideList.DEFAULT, defaultSprite);
    }

    public BakedModelRetexturable(IRetexturableModel baseModel, String textureVariable, IBlockState particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList itemOverride, TextureAtlasSprite defaultSprite) {
        this(baseModel, textureVariable, (Function<ResourceLocation, TextureAtlasSprite>)((Function)location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString())), transforms, true, true, false, particle, ItemCameraTransforms.field_178357_a, itemOverride, defaultSprite);
    }

    public BakedModelRetexturable(IRetexturableModel baseModel, String textureVariable, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, boolean ambientOcclusion, boolean gui3d, boolean builtin, IBlockState particle, ItemCameraTransforms cameraTransforms, ItemOverrideList itemOverride, TextureAtlasSprite defaultSprite) {
        this.baseModel = baseModel;
        this.textureVariable = textureVariable;
        this.spriteGetter = spriteGetter;
        this.transforms = transforms;
        this.ambientOcclusion = ambientOcclusion;
        this.gui3D = gui3d;
        this.builtin = builtin;
        this.particle = particle;
        this.cameraTransforms = cameraTransforms;
        this.itemOverride = itemOverride;
        this.defaultSprite = defaultSprite;
    }

    public IBakedModel getRetexturedModel(String textureName) {
        BakedModelRetexturable model = this;
        if (this.cache.containsKey(textureName)) {
            model = this.cache.get(textureName);
        } else if (this.baseModel != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)this.textureVariable, (Object)textureName);
            IModel retexturedModel = this.baseModel.retexture(builder.build());
            SimpleModelState modelState = new SimpleModelState(this.transforms);
            model = retexturedModel.bake((IModelState)modelState, DefaultVertexFormats.field_176600_a, this.spriteGetter);
            this.cache.put(textureName, (IBakedModel)model);
        }
        return model;
    }

    public IBakedModel getDefaultModel() {
        return this.getRetexturedModel(this.defaultSprite.func_94215_i());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state != null) {
            IBlockState heldState = (IBlockState)((IExtendedBlockState)state).getValue(Blockstates.HELD_STATE);
            if (heldState != null) {
                return this.getRetexturedModel(RenderUtils.getSprite(heldState).func_94215_i()).func_188616_a(state, side, rand);
            }
            if (this.defaultSprite != null) {
                return this.getRetexturedModel(this.defaultSprite.func_94215_i()).func_188616_a(state, side, rand);
            }
        }
        return RenderUtils.getMissingquads(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public boolean func_177556_c() {
        return this.gui3D;
    }

    public boolean func_188618_c() {
        return this.builtin;
    }

    public TextureAtlasSprite func_177554_e() {
        return RenderUtils.getSprite(this.particle);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.cameraTransforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverride;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

