/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.config.Config;
import net.darkhax.bookshelf.config.Configurable;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.AnnotationUtils;
import net.darkhax.bookshelf.util.CollectionUtils;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConfigurationHandler {
    public static final Multimap<String, Class<?>> CLASS_CACHE = HashMultimap.create();
    public static final Map<Class<?>, Adapter> handlers = new HashMap();
    private final String name;
    private final File file;
    private final Configuration config;
    private Field[] properties;

    public ConfigurationHandler(String name) {
        this.name = name;
        this.file = new File(Loader.instance().getConfigDir(), name.toLowerCase() + ".cfg");
        this.config = new Configuration(this.file);
    }

    public void init(ASMDataTable table) {
        if (CLASS_CACHE.isEmpty()) {
            for (Tuple<Class<?>, Config> data : AnnotationUtils.getAnnotatedClasses(table, Config.class)) {
                if (data.func_76340_b() == null) continue;
                CLASS_CACHE.put((Object)((Config)data.func_76340_b()).name(), data.func_76341_a());
            }
        }
        this.properties = AnnotationUtils.getAnnotatedFields(CLASS_CACHE.get((Object)this.name), Configurable.class).toArray(new Field[0]);
    }

    public void sync() {
        this.config.load();
        for (Field field : this.properties) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) {
                Constants.LOG.info("Configuration fields must be public, and static!");
                continue;
            }
            field.setAccessible(true);
            Configurable configurable = field.getAnnotation(Configurable.class);
            String propName = configurable.name().isEmpty() ? field.getName() : configurable.name();
            Class<?> type = field.getType();
            if (handlers.containsKey(type)) {
                try {
                    Object result = handlers.get(type).read(propName, configurable.category(), configurable.description(), this.config, field.get(null));
                    field.set(null, result);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Constants.LOG.info("Error handling configurable field! Could not read/write " + field.getName(), (Throwable)e);
                }
                continue;
            }
            Constants.LOG.info("Unhandled type: " + type.getCanonicalName());
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase(this.name)) {
            this.sync();
        }
    }

    public boolean hasChanged() {
        return this.config.hasChanged();
    }

    public void save() {
        this.config.save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static <T> void addReader(Class<T> type, Adapter<T> reader) {
        handlers.put(type, reader);
    }

    private static boolean readBoolean(String name, String category, String comment, Configuration config, boolean object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getBoolean();
    }

    private static boolean[] readBooleanArray(String name, String category, String comment, Configuration config, boolean[] object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getBooleanList();
    }

    private static double readDouble(String name, String category, String comment, Configuration config, double object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getDouble();
    }

    private static double[] readDoubleArray(String name, String category, String comment, Configuration config, double[] object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getDoubleList();
    }

    private static float readFloat(String name, String category, String comment, Configuration config, float object) {
        return (float)ConfigurationHandler.readDouble(name, category, comment, config, object);
    }

    private static float[] readFloatArray(String name, String category, String comment, Configuration config, float[] object) {
        return CollectionUtils.toFloat(ConfigurationHandler.readDoubleArray(name, category, comment, config, CollectionUtils.toDouble(object)));
    }

    private static int readInt(String name, String category, String comment, Configuration config, int object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getInt();
    }

    private static int[] readIntArray(String name, String category, String comment, Configuration config, int[] object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getIntList();
    }

    private static String readString(String name, String category, String comment, Configuration config, String object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getString();
    }

    private static String[] readStringArray(String name, String category, String comment, Configuration config, String[] object) {
        return ConfigurationHandler.setComment(config.get(category, name, object), comment).getStringList();
    }

    private static ResourceLocation readIdentifier(String name, String category, String comment, Configuration config, ResourceLocation object) {
        return new ResourceLocation(ConfigurationHandler.readString(name, category, comment, config, object.toString()));
    }

    private static ResourceLocation[] readIdentifierArray(String name, String category, String comment, Configuration config, ResourceLocation[] object) {
        return CollectionUtils.toIdentifier(ConfigurationHandler.readStringArray(name, category, comment, config, CollectionUtils.toString(object)));
    }

    private static Item readItem(String name, String category, String comment, Configuration config, Item object) {
        return (Item)ForgeRegistries.ITEMS.getValue(ConfigurationHandler.readIdentifier(name, category, comment, config, object.getRegistryName()));
    }

    private static Item[] readItemArray(String name, String category, String comment, Configuration config, Item[] object) {
        return CollectionUtils.toItem(ConfigurationHandler.readIdentifierArray(name, category, comment, config, CollectionUtils.toIdentifier(object)));
    }

    private static Block readBlock(String name, String category, String comment, Configuration config, Block object) {
        return (Block)ForgeRegistries.BLOCKS.getValue(ConfigurationHandler.readIdentifier(name, category, comment, config, object.getRegistryName()));
    }

    private static Block[] readBlockArray(String name, String category, String comment, Configuration config, Block[] object) {
        return CollectionUtils.toBlock(ConfigurationHandler.readIdentifierArray(name, category, comment, config, CollectionUtils.toIdentifier(object)));
    }

    private static ItemStack readItemStack(String name, String category, String comment, Configuration config, ItemStack object) {
        return StackUtils.createStackFromString(ConfigurationHandler.readString(name, category, comment, config, StackUtils.writeStackToString(object)));
    }

    private static ItemStack[] readItemStackArray(String name, String category, String comment, Configuration config, ItemStack[] object) {
        return CollectionUtils.toStack(ConfigurationHandler.readStringArray(name, category, comment, config, CollectionUtils.toString(object)));
    }

    private static Color readColor(String name, String category, String comment, Configuration config, Color object) {
        return CollectionUtils.toColor(ConfigurationHandler.readIntArray(name, category, comment, config, CollectionUtils.toInt(object)));
    }

    private static BlockPos readPos(String name, String category, String comment, Configuration config, BlockPos object) {
        return CollectionUtils.toPos(ConfigurationHandler.readIntArray(name, category, comment, config, CollectionUtils.toInt(object)));
    }

    private static Property setComment(Property property, String comment) {
        property.setComment(comment);
        return property;
    }

    static {
        ConfigurationHandler.addReader(Boolean.TYPE, ConfigurationHandler::readBoolean);
        ConfigurationHandler.addReader(boolean[].class, ConfigurationHandler::readBooleanArray);
        ConfigurationHandler.addReader(Double.TYPE, ConfigurationHandler::readDouble);
        ConfigurationHandler.addReader(double[].class, ConfigurationHandler::readDoubleArray);
        ConfigurationHandler.addReader(Float.TYPE, ConfigurationHandler::readFloat);
        ConfigurationHandler.addReader(float[].class, ConfigurationHandler::readFloatArray);
        ConfigurationHandler.addReader(Integer.TYPE, ConfigurationHandler::readInt);
        ConfigurationHandler.addReader(int[].class, ConfigurationHandler::readIntArray);
        ConfigurationHandler.addReader(String.class, ConfigurationHandler::readString);
        ConfigurationHandler.addReader(String[].class, ConfigurationHandler::readStringArray);
        ConfigurationHandler.addReader(ResourceLocation.class, ConfigurationHandler::readIdentifier);
        ConfigurationHandler.addReader(ResourceLocation[].class, ConfigurationHandler::readIdentifierArray);
        ConfigurationHandler.addReader(Item.class, ConfigurationHandler::readItem);
        ConfigurationHandler.addReader(Item[].class, ConfigurationHandler::readItemArray);
        ConfigurationHandler.addReader(Block.class, ConfigurationHandler::readBlock);
        ConfigurationHandler.addReader(Block[].class, ConfigurationHandler::readBlockArray);
        ConfigurationHandler.addReader(ItemStack.class, ConfigurationHandler::readItemStack);
        ConfigurationHandler.addReader(ItemStack[].class, ConfigurationHandler::readItemStackArray);
        ConfigurationHandler.addReader(BlockPos.class, ConfigurationHandler::readPos);
        ConfigurationHandler.addReader(Color.class, ConfigurationHandler::readColor);
    }

    public static interface Adapter<T> {
        public T read(String var1, String var2, String var3, Configuration var4, T var5);
    }
}

