/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.item;

import java.util.ArrayList;
import net.darkhax.bookshelf.block.BlockBasicChest;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicChest;
import net.darkhax.bookshelf.builder.ChestBuilder;
import net.darkhax.bookshelf.item.ICustomMesh;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockChest
extends ItemBlock
implements ICustomMesh {
    private final ChestBuilder builder;

    public ItemBlockChest(Block block, ChestBuilder builder) {
        super(block);
        this.func_77627_a(true);
        this.builder = builder;
    }

    public String func_77667_c(ItemStack stack) {
        BlockBasicChest cChest = (BlockBasicChest)this.func_179223_d();
        ChestBuilder.IChestType myType = cChest.getCustomType(stack);
        return myType != null ? this.field_150939_a.func_149739_a() + "." + myType.getName() + (cChest.isTrapChest() ? ".trap" : "") : this.field_150939_a.func_149739_a();
    }

    public int func_77647_b(int damage) {
        return 0;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity te;
        int typeCnt = 0;
        BlockPos posN = pos.func_177978_c();
        BlockPos posS = pos.func_177968_d();
        BlockPos posW = pos.func_177976_e();
        BlockPos posE = pos.func_177974_f();
        BlockBasicChest cChest = (BlockBasicChest)this.func_179223_d();
        ChestBuilder.IChestType myType = cChest.getCustomType(stack);
        if (world.func_180495_p(posN).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posN) == myType) {
            typeCnt += cChest.isDoubleChest(world, posN, myType) ? 2 : 1;
        }
        if (world.func_180495_p(posS).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posS) == myType) {
            typeCnt += cChest.isDoubleChest(world, posS, myType) ? 2 : 1;
        }
        if (world.func_180495_p(posW).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posW) == myType) {
            typeCnt += cChest.isDoubleChest(world, posW, myType) ? 2 : 1;
        }
        if (world.func_180495_p(posE).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posE) == myType) {
            typeCnt += cChest.isDoubleChest(world, posE, myType) ? 2 : 1;
        }
        if (typeCnt <= 1 && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState) && (te = world.func_175625_s(pos)) instanceof TileEntityBasicChest) {
            ((TileEntityBasicChest)te).setType(myType);
            return true;
        }
        return false;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        BlockBasicChest chest = (BlockBasicChest)Block.func_149634_a((Item)itemIn);
        for (ChestBuilder.IChestType type : chest.getBuilder().getTypes()) {
            subItems.add((Object)chest.setCustomType(new ItemStack(itemIn, 1), type));
        }
    }

    @Override
    public ItemMeshDefinition getCustomMesh() {
        return stack -> {
            BlockBasicChest chest = (BlockBasicChest)this.func_179223_d();
            ChestBuilder.IChestType type = ((BlockBasicChest)this.func_179223_d()).getCustomType(stack);
            return chest.field_149956_a == chest.getBuilder().getNormalType() ? type.getNormalItemModel() : type.getTrapItemModel();
        };
    }

    @Override
    public void registerMeshModels() {
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
        for (ChestBuilder.IChestType type : this.builder.getTypes()) {
            models.add(new ResourceLocation(this.builder.getModid(), "chest_" + type.getName()));
            if (!this.builder.useTraps()) continue;
            models.add(new ResourceLocation(this.builder.getModid(), "chest_trap_" + type.getName()));
        }
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])models.toArray(new ResourceLocation[models.size()]));
    }

    public ChestBuilder getBuilder() {
        return this.builder;
    }
}

