/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MCColor
extends Color {
    private static final long serialVersionUID = -6408679408589215496L;

    public MCColor(@Nonnull ItemStack stack) {
        this(stack.func_77978_p());
    }

    public MCColor(IBlockAccess world, BlockPos pos) {
        this(world.func_175625_s(pos));
    }

    public MCColor(TileEntity tile) {
        this(tile.getTileData());
    }

    public MCColor(@Nonnull NBTTagCompound tag) {
        this(tag.func_74759_k("Color"));
    }

    public MCColor(@Nonnull int[] colors) {
        this(colors[0], colors[1], colors[2]);
    }

    public MCColor(int red, int green, int blue) {
        super(red, green, blue);
    }

    public MCColor(String string) {
        this(string.hashCode());
    }

    public MCColor(int packed) {
        super(packed);
    }

    public void writeToStack(@Nonnull ItemStack stack) {
        this.writeToNBT(stack.func_77978_p());
    }

    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        tag.func_74783_a("Color", new int[]{this.getRed(), this.getGreen(), this.getBlue()});
    }

    public int[] getComponents() {
        return new int[]{this.getRed(), this.getGreen(), this.getBlue()};
    }

    public float getRedF() {
        return (float)this.getRed() / 255.0f;
    }

    public float getGreenF() {
        return (float)this.getGreen() / 255.0f;
    }

    public float getBlueF() {
        return (float)this.getBlue() / 255.0f;
    }

    public void setRenderColor() {
        GlStateManager.func_179124_c((float)this.getRed(), (float)this.getGreen(), (float)this.getBlue());
    }

    public static MCColor getRandomColor(@Nonnull Random rand) {
        return new MCColor(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256));
    }

    public static boolean isAcceptable(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && MCColor.isAcceptable(stack.func_77978_p());
    }

    public static boolean isAcceptable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return MCColor.isAcceptable(world.func_175625_s(pos));
    }

    public static boolean isAcceptable(@Nonnull TileEntity tile) {
        return tile != null && !tile.func_145837_r() && MCColor.isAcceptable(tile.getTileData());
    }

    public static boolean isAcceptable(@Nonnull NBTTagCompound tag) {
        return tag.func_74764_b("Color") && tag.func_74759_k("Color").length == 3;
    }
}

