/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.darkhax.bookshelf.builder.LootBuilder;
import net.darkhax.bookshelf.item.ICustomMesh;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.registry.IVariant;
import net.darkhax.bookshelf.util.GameUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RegistryHelper {
    public static final List<RegistryHelper> HELPERS = NonNullList.func_191196_a();
    private static final List<ICustomMesh> customMeshes = NonNullList.func_191196_a();
    private final String modid;
    private final NonNullList<Item> items = NonNullList.func_191196_a();
    private final NonNullList<Block> blocks = NonNullList.func_191196_a();
    private final Multimap<ResourceLocation, LootBuilder> lootTableEntries = HashMultimap.create();
    private CreativeTabs tab;
    private final boolean enableAutoModelReg;

    public RegistryHelper(@Nonnull String modid) {
        this(modid, true);
    }

    public RegistryHelper(@Nonnull String modid, boolean autoModels) {
        this.modid = modid;
        this.enableAutoModelReg = autoModels;
        MinecraftForge.EVENT_BUS.register((Object)this);
        HELPERS.add(this);
    }

    public CreativeTabs getTab() {
        return this.tab;
    }

    public RegistryHelper setTab(CreativeTabs tab) {
        this.tab = tab;
        return this;
    }

    public String getModid() {
        return this.modid;
    }

    public NonNullList<Item> getItems() {
        return this.items;
    }

    public NonNullList<Block> getBlocks() {
        return this.blocks;
    }

    public Block registerBlock(@Nonnull Block block, @Nonnull String id) {
        return this.registerBlock(block, new ItemBlock(block), id);
    }

    public Block registerBlock(@Nonnull Block block, @Nonnull ItemBlock itemBlock, @Nonnull String id) {
        block.setRegistryName(this.modid, id);
        block.func_149663_c(this.modid + "." + id.toLowerCase().replace("_", "."));
        this.registerItem((Item)itemBlock, block.getRegistryName());
        this.blocks.add((Object)block);
        if (this.tab != null) {
            block.func_149647_a(this.tab);
        }
        return block;
    }

    public Item registerItem(@Nonnull Item item, @Nonnull String id) {
        return this.registerItem(item, new ResourceLocation(this.modid, id));
    }

    public Item registerItem(@Nonnull Item item, @Nonnull ResourceLocation id) {
        item.setRegistryName(id);
        item.func_77655_b(id.func_110624_b().replaceAll("_", ".") + "." + id.func_110623_a().toLowerCase().replace("_", "."));
        this.items.add((Object)item);
        if (this.tab != null) {
            item.func_77637_a(this.tab);
        }
        if (GameUtils.isClient() && item instanceof ICustomMesh) {
            ICustomMesh mesh = (ICustomMesh)item;
            customMeshes.add(mesh);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh.getCustomMesh());
        }
        return item;
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, Item item) {
        return this.addLoot(location, new LootBuilder(this.modid + ":" + name, pool, weight, item));
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, int quality, Item item, List<LootCondition> conditions, List<LootFunction> functions) {
        return this.addLoot(location, new LootBuilder(this.modid + ":" + name, pool, weight, quality, item, conditions, functions));
    }

    public LootBuilder addLoot(ResourceLocation location, LootBuilder builder) {
        this.lootTableEntries.put((Object)location, (Object)builder);
        return builder;
    }

    @SubscribeEvent
    public void onTableLoaded(LootTableLoadEvent event) {
        for (LootBuilder builder : this.lootTableEntries.get((Object)event.getName())) {
            LootPool pool = event.getTable().getPool(builder.getPool());
            if (pool != null) {
                pool.addEntry((LootEntry)builder.build());
                continue;
            }
            Constants.LOG.info(String.format("The mod %s tried to add loot to %s but the pool was not found. %s", this.modid, event.getName(), builder.toString()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColorHandler(@Nonnull Block block, @Nonnull IBlockColor color) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(color, new Block[]{block});
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColorHandler(@Nonnull Item item, @Nonnull IItemColor color) {
        Minecraft.func_71410_x().getItemColors().func_186730_a(color, new Item[]{item});
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Block block) {
        this.registerInventoryModel(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Block block, @Nonnull String prefix, String ... variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            this.registerInventoryModel(Item.func_150898_a((Block)block), meta, block.getRegistryName().toString() + "_" + (prefix.isEmpty() ? prefix : prefix + "_") + variants[meta]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Block block, int meta, @Nonnull String modelName) {
        this.registerInventoryModel(Item.func_150898_a((Block)block), meta, modelName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Item item) {
        if (item instanceof IVariant) {
            IVariant variant = (IVariant)item;
            this.registerInventoryModel(item, variant.getPrefix(), variant.getVariant());
        } else {
            this.registerInventoryModel(item, 0, item.getRegistryName().toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Item item, @Nonnull String prefix, String ... variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            this.registerInventoryModel(item, meta, item.getRegistryName().toString() + "_" + (prefix.isEmpty() ? prefix : prefix + "_") + variants[meta]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Item item, int meta, @Nonnull String modelName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(modelName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientPreInit() {
        for (RegistryHelper helper : HELPERS) {
            if (!helper.enableAutoModelReg) continue;
            for (Block block : helper.blocks) {
                helper.registerInventoryModel(block);
            }
            for (Item item : helper.items) {
                helper.registerInventoryModel(item);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientInit() {
        for (ICustomMesh mesh : customMeshes) {
            mesh.registerMeshModels();
        }
    }
}

